---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：29-getStaticPaths

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **C-14**：fallback: trueのフォールバック版先行レスポンスの具体的実装

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/static-paths/pages.ts` - buildPagesStaticPaths実装
- E-02: `packages/next/src/server/render.tsx` - getStaticPaths関連チェック
- E-03: `packages/next/src/shared/lib/router/utils/route-regex.ts` - ルート正規表現
- E-04: `packages/next/src/shared/lib/router/utils/route-matcher.ts` - ルートマッチング
- E-05: `packages/next/src/types.ts` - GetStaticPaths型定義
- E-06: `packages/next/src/lib/fallback.ts` - fallback解析
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 動的ルートでのみ使用可能 | E-02 (583-588行目) | ○ |
| C-02 | getStaticPropsとの組み合わせが必要 | E-02 (590-593行目) | ○ |
| C-03 | fallbackプロパティ必須 | E-01 (65-75行目) | ○ |
| C-04 | 戻り値がオブジェクトでないとエラー | E-01 (43-51行目) | ○ |
| C-05 | paths/fallback以外のキーがあるとエラー | E-01 (53-63行目) | ○ |
| C-06 | pathsが配列でないとエラー | E-01 (79-84行目) | ○ |
| C-07 | 文字列パスの場合はルートマッチャーで検証 | E-01 (89-100行目) | ○ |
| C-08 | i18n正規化処理 | E-01 (92-98行目) | ○ |
| C-09 | getRouteRegexとgetRouteMatcherの使用 | E-01 (26-30行目) | ○ |
| C-10 | fallback: booleanまたは'blocking'の型チェック | E-01 (65-75行目) | ○ |
| C-11 | locales/defaultLocaleのコンテキスト提供 | E-01 (31-37行目) | ○ |
| C-12 | ビルド時に1回のみ実行 | E-01 (ビルドスクリプトから呼び出し) | ○ |
| C-13 | App RouterではgenerateStaticParamsが代替 | E-07 | ○ |
| C-14 | fallback: trueでフォールバック版を先行レスポンス | **根拠なし** (ランタイム側の実装未確認) | △ |

## 4) 不足情報（Unknown / Missing）
- fallback: trueのランタイム側実装（フォールバックHTML提供とバックグラウンド生成）
  - 候補：`packages/next/src/server/base-server.ts` / `packages/next/src/server/render.tsx`のfallback処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - buildPagesStaticPathsのバリデーションは詳細に確認済み
- 0: 低リスク - render.tsxの排他制約チェックは確認済み
- 1: 中リスク - fallbackのランタイム挙動の具体的実装は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] buildPagesStaticPathsのバリデーションロジックが最新か確認
- [ ] パス文字列のルートマッチング検証が正確か確認
- [ ] fallback: true/blocking のランタイム挙動をbase-server.tsで確認
