---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：31-カスタムApp

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **reportWebVitals連携の詳細**：ソースコード上の実装参照が不十分
  2. **ページ遷移時のアンマウント動作**：公式ドキュメント依存の主張
  3. **自動静的最適化の無効化条件**：ビルドプロセス側の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/pages/_app.tsx` - デフォルトAppコンポーネント実装
- E-02: `packages/next/src/shared/lib/utils.ts` - 型定義とloadGetInitialProps関数
- E-03: `packages/next/src/server/load-components.ts` - コンポーネント読み込みロジック
- E-04: `packages/next/src/server/route-modules/pages/module.ts` - PagesRouteModule
- E-05: `packages/next/src/server/render.tsx` - レンダリング処理
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カスタムAppは全ページコンポーネントのラッパーとして機能する | E-01 (34-45行目), E-04 (148行目) | ○ |
| C-02 | デフォルトのgetInitialPropsはloadGetInitialPropsを呼び出す | E-01 (30行目), E-02 (361-411行目) | ○ |
| C-03 | AppPropsTypeにComponent, router, __N_SSG, __N_SSPが含まれる | E-02 (174-182行目) | ○ |
| C-04 | インスタンスメソッドとして定義した場合にエラーがスローされる | E-02 (367-373行目) | ○ |
| C-05 | 空オブジェクト返却時に警告ログが出力される | E-02 (400-408行目) | ○ |
| C-06 | loadComponentsで_appモジュールが読み込まれる | E-03 (183-186行目) | ○ |
| C-07 | PagesRouteModuleがAppコンポーネントを使用する | E-04 (70-82行目, 141-153行目) | ○ |
| C-08 | getInitialPropsの戻り値がnullの場合にエラー | E-02 (393-398行目) | ○ |
| C-09 | renderPageTreeでAppがComponentをラップする | E-05 (235-241行目) | ○ |
| C-10 | origGetInitialPropsが設定されている | E-01 (38行目) | ○ |
| C-11 | 画面No.3がアプリケーションラッパーとして関連 | E-06 | ○ |
| C-12 | 機能No.31がカスタムAppとして定義されている | E-07 | ○ |
| C-13 | レスポンス送信済みの場合はpropsをそのまま返す | E-02 (389-391行目) | ○ |
| C-14 | reportWebVitalsによるWeb Vitals計測が可能 | E-02 (44-63行目 型定義のみ) | ○ |
| C-15 | ページ遷移時にAppコンポーネントはアンマウントされない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15の「ページ遷移時にAppコンポーネントはアンマウントされない」はReactの一般的な動作原理に基づく主張であり、Next.jsソースコード上で直接確認できる箇所が不十分
  - 候補：クライアントサイドルーター実装 / Reactの再利用ロジック / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い
- 1: 中リスク - ページ遷移時の状態保持の説明は公式ドキュメント依存

## 6) レビュアーチェックリスト（最小）
- [ ] C-15: ページ遷移時のAppアンマウント動作について、クライアントサイドルーター実装を確認
- [ ] reportWebVitalsの実装詳細がsrc/client/web-vitals.ts等に存在するか確認
- [ ] 自動静的最適化の無効化条件がビルドプロセスと整合するか確認
