---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-カスタムDocument

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/pages/_document.tsx` - デフォルトDocumentコンポーネント実装
- E-02: `packages/next/src/shared/lib/utils.ts` - Document関連型定義
- E-03: `packages/next/src/server/load-components.ts` - Documentモジュール読み込み
- E-04: `packages/next/src/shared/lib/html-context.shared-runtime.ts` - HtmlContext定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DocumentはHTMLドキュメント構造のカスタマイズ機能を提供する | E-01 (962-984行目) | ○ |
| C-02 | サーバーサイドでのみレンダリングされる | E-01 (958-960行目 コメント), E-06 | ○ |
| C-03 | getInitialPropsはctx.defaultGetInitialPropsを呼び出す | E-01 (969-971行目) | ○ |
| C-04 | Head内でtitleタグ使用時に警告が出る | E-01 (623-625行目) | ○ |
| C-05 | Head内でviewport metaタグ使用時に警告が出る | E-01 (628-631行目) | ○ |
| C-06 | __NEXT_DATA__のサイズ超過時に警告が出る | E-01 (830-845行目) | ○ |
| C-07 | 開発モードでFOUC防止のbody display:noneが注入される | E-01 (669-685行目) | ○ |
| C-08 | getDocumentFilesがBuildManifestからファイルリストを取得する | E-01 (54-66行目) | ○ |
| C-09 | NextScriptが__NEXT_DATA__をJSON形式で埋め込む | E-01 (899-909行目) | ○ |
| C-10 | HtmlコンポーネントがlangとdeploymentIdを設定する | E-01 (943-948行目) | ○ |
| C-11 | MainコンポーネントがbodyRenderTargetを提供する | E-01 (951-956行目) | ○ |
| C-12 | NEXT_BUILTIN_DOCUMENTでカスタム検出が可能 | E-01 (988-1000行目) | ○ |
| C-13 | getNextFontLinkTagsがフォントpreload/preconnectを生成する | E-01 (311-364行目) | ○ |
| C-14 | handleDocumentScriptLoaderItemsがbeforeInteractiveスクリプトを処理する | E-01 (735-790行目) | ○ |
| C-15 | loadComponentsで_documentモジュールが読み込まれる | E-03 (183行目) | ○ |
| C-16 | 画面No.2がドキュメントとして関連 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] _document.tsxの全体構造がテンプレートの記述と整合するか確認
- [ ] optimizeCssとdisableOptimizedLoadingの組み合わせによる動作差異を確認
