---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-カスタムエラーページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/pages/_error.tsx` - デフォルトエラーページ実装
- E-02: `packages/next/src/shared/lib/utils.ts` - NextPageContext型定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | statusCodesマップに400/404/405/500が定義されている | E-01 (5-10行目) | ○ |
| C-02 | ErrorPropsにstatusCode/hostname/title/withDarkModeが含まれる | E-01 (12-17行目) | ○ |
| C-03 | ステータスコードはres.statusCode > err.statusCode > 404の優先順位 | E-01 (24-25行目) | ○ |
| C-04 | クライアントサイドではwindow.location.hostnameを使用 | E-01 (29-30行目) | ○ |
| C-05 | サーバーサイドではgetRequestMetaからinitURLを取得 | E-01 (32-39行目) | ○ |
| C-06 | withDarkModeはデフォルトtrue | E-01 (88行目) | ○ |
| C-07 | displayNameはErrorPageに設定 | E-01 (82行目) | ○ |
| C-08 | ダークモードはprefers-color-schemeメディアクエリで対応 | E-01 (123-127行目) | ○ |
| C-09 | スタイルはFlexboxによる中央配置 | E-01 (46-56行目) | ○ |
| C-10 | statusCodeなしの場合クライアントサイドエラーメッセージ表示 | E-01 (141-148行目) | ○ |
| C-11 | origGetInitialPropsが設定されている | E-01 (85行目) | ○ |
| C-12 | 画面No.1がエラーページとして関連 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ステータスコード優先順位のロジックがドキュメントの記述と整合するか確認
- [ ] hostname取得ロジックのサーバー/クライアント分岐が正しいか確認
