---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：34-サーバーサイドレンダリング（SSR）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Cache-Controlヘッダーのデフォルト値**：具体的なヘッダー値の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/render.tsx` - SSRレンダリングの中核実装
- E-02: `packages/next/src/server/load-components.ts` - コンポーネント読み込み
- E-03: `packages/next/src/server/route-modules/pages/module.ts` - PagesRouteModule
- E-04: `packages/next/src/server/stream-utils/node-web-streams-helper.ts` - ストリーム処理
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | renderToHTMLImplがSSRの中核関数 | E-01 (444-453行目) | ○ |
| C-02 | isSSGはgetStaticPropsの存在で判定 | E-01 (519行目) | ○ |
| C-03 | isAutoExportの判定ロジック | E-01 (547-551行目) | ○ |
| C-04 | SSGとgetInitialPropsは排他 | E-01 (565-567行目) | ○ |
| C-05 | SSRとSSGは排他 | E-01 (573-575行目) | ○ |
| C-06 | getServerSidePropsとgetInitialPropsは排他 | E-01 (569-571行目) | ○ |
| C-07 | output:exportとgetServerSidePropsは排他 | E-01 (577-581行目) | ○ |
| C-08 | 非動的ページでのgetStaticPathsはエラー | E-01 (583-588行目) | ○ |
| C-09 | renderPageTreeでAppがComponentをラップ | E-01 (235-241行目) | ○ |
| C-10 | renderToStringがReactDOMServer.renderToReadableStreamを使用 | E-01 (137-141行目) | ○ |
| C-11 | コンポーネントのReact要素チェック（開発モード） | E-01 (606-624行目) | ○ |
| C-12 | loadComponentsでApp/Document/Componentを読み込み | E-02 (182-308行目) | ○ |
| C-13 | PagesRouteModule.renderがrenderToHTMLImplを呼び出す | E-03 (141-153行目) | ○ |
| C-14 | SSRのデフォルトCache-Controlヘッダー値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14のCache-Controlヘッダーのデフォルト値について、render.tsx内の設定箇所の直接確認が不十分
  - 候補：next-server.ts / router-server.ts / cache-control.ts

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SSRの基本フローはソースコードで網羅的に確認済み
- 1: 中リスク - Cache-Controlヘッダーのデフォルト値は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] C-14: SSRのデフォルトCache-Controlヘッダー値を確認
- [ ] getServerSidePropsの戻り値検証ロジックの詳細を確認
- [ ] App Routerでの Server Components SSRとの差異を確認
