---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：35-静的サイト生成（SSG）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **fallback: 'blocking'の非推奨予定**：公式ドキュメント依存

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/static-paths/pages.ts` - Pages Router SSG実装
- E-02: `packages/next/src/server/render.tsx` - SSG判定とレンダリング
- E-03: `packages/next/src/build/static-paths/types.ts` - SSG型定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getStaticPathsはpathsとfallbackを返す | E-01 (53-75行目) | ○ |
| C-02 | 動的ルートでSSG使用時にgetStaticPathsが必須 | E-02 (596-601行目) | ○ |
| C-03 | getStaticPathsが非動的ページで使用されるとエラー | E-02 (583-588行目) | ○ |
| C-04 | getStaticPathsがgetStaticPropsなしで使用されるとエラー | E-02 (590-594行目) | ○ |
| C-05 | isSSGはgetStaticPropsの存在で判定 | E-02 (519行目) | ○ |
| C-06 | SSGとgetInitialPropsは排他 | E-02 (565-567行目) | ○ |
| C-07 | fallback値はbooleanまたは'blocking' | E-01 (65-75行目) | ○ |
| C-08 | 戻り値の基本検証（object/arrayチェック） | E-01 (43-63行目) | ○ |
| C-09 | localesとdefaultLocaleがgetStaticPathsに渡される | E-01 (31-37行目) | ○ |
| C-10 | ルート正規表現とマッチャーの取得 | E-01 (26-27行目) | ○ |
| C-11 | isBuildTimeSSGの判定 | E-02 (520行目) | ○ |
| C-12 | App RouterではgenerateStaticParamsに相当 | E-04 | ○ |
| C-13 | fallback: 'blocking'が将来非推奨となる可能性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13の「fallback: 'blocking'の非推奨予定」は公式ドキュメントやRFC等の外部情報源に基づく主張であり、ソースコード内に直接的な根拠がない
  - 候補：Next.js公式ドキュメント / GitHub RFC / CHANGELOG

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SSGの基本仕様はソースコードで確認済み
- 1: 中リスク - fallback: 'blocking'の将来的な非推奨について確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] C-13: fallback: 'blocking'の非推奨予定について公式情報源を確認
- [ ] App Router側のgenerateStaticParamsとの差異を確認
- [ ] ビルドプロセス側のSSG処理フロー詳細を確認
