---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：41-fetch拡張（データキャッシュ）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **NEXT_CACHE_TAG_MAX_LENGTH/ITEMS定数値**：constants.tsの具体値未確認
  2. **FetchMetric型定義箇所**：base-http.tsの参照行番号未特定
  3. **CACHE_ONE_YEAR具体値**：constants.tsのインポートは確認済みだが値は推定

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/lib/patch-fetch.ts`（1304行）
- E-02: `packages/next/src/server/lib/dedupe-fetch.ts`（130行）
- E-03: `packages/next/src/server/response-cache/types.ts`（293行）
- E-04: `packages/next/src/lib/constants.ts`（インポート確認）
- E-05: 機能一覧.csv 41行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | patchFetch()でグローバルfetchをパッチする | E-01 (1280-1290行目) | ○ |
| C-02 | createDedupeFetchで重複排除を行う | E-01 (1286行目), E-02 | ○ |
| C-03 | next.revalidateとnext.tagsオプションをサポート | E-01 (343-357行目) | ○ |
| C-04 | IncrementalCacheと統合してfetchレスポンスを永続化 | E-01 (161-166, 213-218行目) | ○ |
| C-05 | stale-while-revalidateパターンでバックグラウンド再検証 | E-01 (1003-1031行目) | ○ |
| C-06 | Draft Mode時はキャッシュをバイパス | E-01 (327-329行目) | ○ |
| C-07 | authorization/cookieヘッダーでキャッシュ無効化 | E-01 (497-498行目) | ○ |
| C-08 | CachedFetchDataはheaders/body/status/url構造 | E-03 (41-46行目) | ○ |
| C-09 | bodyはbase64エンコードで保存 | E-01 (153, 205行目) | ○ |
| C-10 | cacheとrevalidateの競合時に警告出力 | E-01 (425-443行目) | ○ |
| C-11 | fetchCacheモード制約違反時にエラースロー | E-01 (593-633行目) | ○ |
| C-12 | Dynamic I/Oで明示設定なしfetchはハンギングプロミス | E-01 (545-586行目) | ○ |
| C-13 | Edge Runtimeでcacheプロパティを削除 | E-01 (1077行目) | ○ |
| C-14 | URLのusername/passwordを除去 | E-01 (270-271行目) | ○ |
| C-15 | incrementalCache.lock()で並行書き込み制御 | E-01 (947行目) | ○ |
| C-16 | React.cacheを使ったURL単位の重複排除 | E-02 (45-48行目) | ○ |
| C-17 | NEXT_OTEL_FETCH_DISABLED=1でスパン無効化 | E-01 (282行目) | ○ |
| C-18 | タグの最大長256、最大128個 | E-04（インポートのみ確認） | △ |

## 4) 不足情報（Unknown / Missing）
- NEXT_CACHE_TAG_MAX_LENGTH / NEXT_CACHE_TAG_MAX_ITEMS の具体値は`constants.ts`で定義されているがファイルを直接確認していない
  - 候補：`packages/next/src/lib/constants.ts` の定数定義

## 5) リスクフラグ（レビュー観点）
- 0: パッチ済みfetchの基本動作（重複排除、キャッシュ制御）は十分に根拠あり
- 0: キャッシュ保存処理のフロー（prerender/dynamic分岐）も根拠あり
- 1: タグの具体的な制限値（最大長・最大数）は定数ファイル未確認のため要検証

## 6) レビュアーチェックリスト（最小）
- [ ] NEXT_CACHE_TAG_MAX_LENGTH / NEXT_CACHE_TAG_MAX_ITEMS の具体値を`packages/next/src/lib/constants.ts`で確認
- [ ] FetchMetric型の定義を`packages/next/src/server/base-http.ts`で確認
- [ ] Edge Runtime固有の動作（cacheプロパティ削除）が実際の動作と一致するか確認
