---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-unstable_cache

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠が存在する。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/web/spec-extension/unstable-cache.ts`（422行）
- E-02: `packages/next/src/server/lib/patch-fetch.ts`（validateRevalidate/validateTags）
- E-03: `packages/next/src/server/response-cache/types.ts`
- E-04: 機能一覧.csv 42行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | revalidate: 0はエラーをスロー | E-01 (71-75行目) | ○ |
| C-02 | fixedKeyはcb.toString() + keyPartsから生成 | E-01 (95-97行目) | ○ |
| C-03 | キャッシュキーはfixedKey + JSON.stringify(args) | E-01 (133行目) | ○ |
| C-04 | ネストされたunstable_cacheはキャッシュをバイパス | E-01 (193-194, 204-211行目) | ○ |
| C-05 | Draft Mode時にキャッシュバイパス | E-01 (211行目) | ○ |
| C-06 | stale時にバックグラウンド再検証を実行 | E-01 (242-291行目) | ○ |
| C-07 | 静的生成中はstaleでブロッキング再検証 | E-01 (285-288行目) | ○ |
| C-08 | キャッシュ保存形式はCachedRouteKind.FETCH | E-01 (40行目) | ○ |
| C-09 | bodyはJSON.stringifyで保存 | E-01 (44行目) | ○ |
| C-10 | innerCacheStoreのtypeは'unstable-cache' | E-01 (143行目) | ○ |
| C-11 | 親スコープにタグとrevalidateを伝播 | E-01 (162-201行目) | ○ |
| C-12 | Pages Router環境ではstale返却を行わない | E-01 (326-382行目) | ○ |
| C-13 | validateTagsでタグバリデーション | E-01 (78-80行目), E-02 | ○ |
| C-14 | cacheSignalのbeginRead/endRead制御 | E-01 (117-119, 384-388行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 全主張にソースコード上の根拠あり
- 0: 処理フローの記述はソースコードの制御構造と一致

## 6) レビュアーチェックリスト（最小）
- [ ] unstable_cacheのネスト回避ロジックが意図通りに動作するか確認
- [ ] Pages Router環境での動作がstale返却なしであることを確認
