---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-cacheLife

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/use-cache/cache-life.ts`（175行）
- E-02: `packages/next/src/server/use-cache/use-cache-wrapper.ts`（collectResult参照）
- E-03: 機能一覧.csv 45行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | "use cache"関数内のみ呼び出し可能 | E-01 (86-103行目) | ○ |
| C-02 | stale/revalidate/expireの3プロパティ | E-01 (5-15行目) | ○ |
| C-03 | プロファイル名はcacheLifeProfilesから解決 | E-01 (106-134行目) | ○ |
| C-04 | expire >= revalidateバリデーション | E-01 (65-74行目) | ○ |
| C-05 | falseは不可でInfinityを使用 | E-01 (36-40, 46-49, 55-59行目) | ○ |
| C-06 | 最小値が優先される | E-01 (147-173行目) | ○ |
| C-07 | __NEXT_USE_CACHEチェック | E-01 (78-82行目) | ○ |
| C-08 | collectResultでexplicit値を参照 | E-02 (436-447行目) | ○ |
| C-09 | Cache-Controlヘッダーとの類似性 | E-01 (16-18行目コメント) | ○ |
| C-10 | カスタムオブジェクトのバリデーション | E-01 (135-145行目) | ○ |
| C-11 | 未定義プロファイルでnext.config.js例を表示 | E-01 (125-132行目) | ○ |
| C-12 | トリムされた名前の提案 | E-01 (119-123行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 175行の小さなファイルで全コードパスを確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] next.config.jsのデフォルトプロファイル定義箇所を確認
