---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-cacheTag

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - 特になし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/use-cache/cache-tag.ts`（40行）
- E-02: `packages/next/src/server/lib/patch-fetch.ts`（validateTags）
- E-03: `packages/next/src/server/use-cache/use-cache-wrapper.ts`（collectResult）
- E-04: 機能一覧.csv 46行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | "use cache"関数内のみ呼び出し可能 | E-01 (13-30行目) | ○ |
| C-02 | __NEXT_USE_CACHEチェック | E-01 (5-9行目) | ○ |
| C-03 | validateTagsでバリデーション | E-01 (32行目) | ○ |
| C-04 | tagsフィールドへの累積追加 | E-01 (34-38行目) | ○ |
| C-05 | 可変長引数で受け取る | E-01 (4行目) | ○ |
| C-06 | cache/private-cacheのみ許可 | E-01 (25-27行目) | ○ |
| C-07 | collectResultでCacheEntryに収集 | E-03 (432-455行目) | ○ |
| C-08 | 戻り値はvoid | E-01 (4行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 40行の小さなファイルで全コードパスを確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] validateTagsの具体的なバリデーションルール（最大長・最大数）を確認
