---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-レスポンスキャッシュ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/response-cache/index.ts`（513行）
- E-02: `packages/next/src/server/response-cache/types.ts`（293行）
- E-03: `packages/next/src/server/response-cache/utils.ts`（99行）
- E-04: `packages/next/src/server/response-cache/web.ts`（131行）
- E-05: 機能一覧.csv 47行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LRUキャッシュによる最小モード管理 | E-01 (138, 229-259行目) | ○ |
| C-02 | invocationID + pathnameのcompoundキー | E-01 (86-91行目) | ○ |
| C-03 | デフォルトTTL 10秒 | E-01 (44-47行目) | ○ |
| C-04 | デフォルトmax 150エントリ | E-01 (53-56行目) | ○ |
| C-05 | Batcherによる重複排除 | E-01 (108-121行目) | ○ |
| C-06 | keyがnullの場合はresponseGenerator直接実行 | E-01 (221-226行目) | ○ |
| C-07 | フレッシュ&非オンデマンド時の即resolve | E-01 (338-346行目) | ○ |
| C-08 | プリフェッチ時はstaleでも再検証しない | E-01 (342行目) | ○ |
| C-09 | エラー時のrevalidate自動調整（3-30秒） | E-01 (486-499行目) | ○ |
| C-10 | fromResponseCacheEntry変換 | E-03 (14-40行目) | ○ |
| C-11 | toResponseCacheEntry変換 | E-03 (42-78行目) | ○ |
| C-12 | scheduleOnNextTickによる非同期処理 | E-01 (120-121行目) | ○ |
| C-13 | LRUエビクション時のinvocationID記録 | E-01 (172-189行目) | ○ |
| C-14 | WebResponseCacheはIncrementalCacheと連携しない | E-04 (7行目コメント, 85-89行目) | ○ |
| C-15 | オンデマンド再検証は別キーで管理 | E-01 (115-116行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 全主張にソースコード上の根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] LRUキャッシュのサイズがプロダクション環境で適切か確認
- [ ] 最小モードでのTTLとinvocationIDの動作を確認
