---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：48-revalidatePath

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **NEXT_CACHE_IMPLICIT_TAG_IDの具体値**：constants.tsで確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/web/spec-extension/revalidate.ts`（238行）
- E-02: `packages/next/src/lib/constants.ts`（インポート確認）
- E-03: 機能一覧.csv 48行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パス長チェック（NEXT_CACHE_SOFT_TAG_MAX_LENGTH） | E-01 (93-98行目) | ○ |
| C-02 | パス正規化（暗黙タグID + removeTrailingSlash） | E-01 (100行目) | ○ |
| C-03 | type追加（/layout, /page） | E-01 (102-103行目) | ○ |
| C-04 | 動的ルートでtype未指定時に警告 | E-01 (104-108行目) | ○ |
| C-05 | ルートパスで'/index'も追加 | E-01 (111-115行目) | ○ |
| C-06 | render phase中はエラー | E-01 (134-138行目) | ○ |
| C-07 | cache/unstable-cache内はエラー | E-01 (141-149行目) | ○ |
| C-08 | prerender時はabortAndThrow | E-01 (150-161行目) | ○ |
| C-09 | pendingRevalidatedTagsに追加 | E-01 (197-219行目) | ○ |
| C-10 | pathWasRevalidated設定 | E-01 (233-236行目) | ○ |
| C-11 | profileパラメータなし | E-01 (117行目) | ○ |
| C-12 | DynamicServerError（prerender-legacy） | E-01 (172-181行目) | ○ |
| C-13 | NEXT_CACHE_IMPLICIT_TAG_IDは'_N_T_' | E-02（定数値未直接確認） | △ |

## 4) 不足情報（Unknown / Missing）
- NEXT_CACHE_IMPLICIT_TAG_IDの具体値を`packages/next/src/lib/constants.ts`で確認する必要がある
  - 候補：`packages/next/src/lib/constants.ts`

## 5) リスクフラグ（レビュー観点）
- 0: revalidate.tsの主要ロジックは全て根拠あり
- 1: 暗黙タグIDの具体値が推定に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] NEXT_CACHE_IMPLICIT_TAG_IDの具体値を確認
- [ ] NEXT_CACHE_SOFT_TAG_MAX_LENGTHの具体値を確認
