---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-revalidateTag

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/web/spec-extension/revalidate.ts`（238行）
- E-02: `packages/next/src/server/use-cache/use-cache-wrapper.ts`（isRecentlyRevalidatedTag）
- E-03: 機能一覧.csv 49行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | revalidateTagの第2引数なしは非推奨警告 | E-01 (30-34行目) | ○ |
| C-02 | updateTagはServer Actions限定 | E-01 (49-55行目) | ○ |
| C-03 | updateTagはprofile未指定で非推奨警告なし | E-01 (57行目) | ○ |
| C-04 | render phase中はエラー | E-01 (134-138行目) | ○ |
| C-05 | cache/unstable-cache内はエラー | E-01 (141-149行目) | ○ |
| C-06 | pendingRevalidatedTagsに重複チェック付きで追加 | E-01 (201-218行目) | ○ |
| C-07 | profile解決（文字列→cacheLifeProfiles） | E-01 (224-231行目) | ○ |
| C-08 | profile未指定/expire===0でpathWasRevalidated設定 | E-01 (233-236行目) | ○ |
| C-09 | refresh()はActionDidRevalidateDynamicOnly | E-01 (83行目) | ○ |
| C-10 | refresh()はServer Actions限定 | E-01 (69-78行目) | ○ |
| C-11 | isRecentlyRevalidatedTagでpendingRevalidatedTags参照 | E-02 (1888-1909行目) | ○ |
| C-12 | profile比較で重複判定（文字列/オブジェクト/undefined） | E-01 (205-211行目) | ○ |
| C-13 | prerender時はabortAndThrow | E-01 (150-161行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 全主張にソースコード上の根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] revalidateTagの第2引数の非推奨警告が適切に表示されるか確認
- [ ] updateTagのServer Action限定チェックが正確に動作するか確認
