---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：50-キャッシュハンドラ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **tags-manifest.external.tsの詳細実装**：areTagsExpired/areTagsStaleの具体的なロジック未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/lib/cache-handlers/types.ts`（81行）
- E-02: `packages/next/src/server/lib/cache-handlers/default.ts`（207行）
- E-03: `packages/next/src/server/use-cache/handlers.ts`（144行）
- E-04: 機能一覧.csv 50行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CacheHandlerインターフェースはget/set/refreshTags/getExpiration/updateTagsの5メソッド | E-01 (42-80行目) | ○ |
| C-02 | CacheEntry.valueはReadableStream<Uint8Array> | E-01 (12行目) | ○ |
| C-03 | maxSize=0の場合はnoop実装 | E-02 (43-51行目) | ○ |
| C-04 | インメモリではrevalidate時間超過でundefined | E-02 (80-90行目) | ○ |
| C-05 | pendingSetsでset中のgetを待機 | E-02 (65-69行目) | ○ |
| C-06 | set時にストリームteeでサイズ計測 | E-02 (135-141行目) | ○ |
| C-07 | グローバルシンボルでハンドラ管理 | E-03 (10-12行目) | ○ |
| C-08 | default/remoteの2種類が標準 | E-03 (55, 59行目) | ○ |
| C-09 | RemoteCache/DefaultCacheのシンボル検出 | E-03 (45-66行目) | ○ |
| C-10 | setCacheHandlerでカスタムハンドラ追加可能 | E-03 (131-143行目) | ○ |
| C-11 | updateTags - durations指定時はstale+expired設定 | E-02 (187-198行目) | ○ |
| C-12 | updateTags - durations未指定時は即時expired | E-02 (200-202行目) | ○ |
| C-13 | getExpiration - expired値の最大値 | E-02 (164-177行目) | ○ |
| C-14 | areTagsExpiredでタグ有効期限チェック | E-02 (94-97行目) | ○ |
| C-15 | areTagsStaleでrevalidate = -1設定 | E-02 (99-102行目) | ○ |
| C-16 | tags-manifest.external.tsの詳細ロジック | **根拠なし**（ファイル未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- tags-manifest.external.tsのareTagsExpired/areTagsStale関数の具体的な実装
  - 候補：`packages/next/src/server/lib/incremental-cache/tags-manifest.external.ts`

## 5) リスクフラグ（レビュー観点）
- 0: CacheHandlerインターフェースとデフォルト実装は全て根拠あり
- 1: タグマニフェストの詳細実装が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] tags-manifest.external.tsのareTagsExpired/areTagsStale実装を確認
- [ ] カスタムCacheHandlerの登録方法（next.config.js）を確認
- [ ] default.external.tsの外部公開用実装を確認
