---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：51-next/link（Link）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **useLinkStatusの詳細動作**：App Routerでのpending状態の具体的な利用方法について根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/link.tsx` - Linkコンポーネント本体（714行）
- E-02: `packages/next/src/client/resolve-href.ts` - href解決ロジック（139行）
- E-03: `packages/next/src/client/use-intersection.tsx` - IntersectionObserverフック（137行）
- E-04: `packages/next/src/client/form-shared.tsx` - 共有フォームユーティリティ
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LinkコンポーネントはforwardRefで定義される | E-01 (295行目) | ○ |
| C-02 | hrefは必須パラメータで文字列またはUrlObject | E-01 (33-39行目, 346-368行目) | ○ |
| C-03 | prefetchのデフォルト値はnull | E-01 (303行目) | ○ |
| C-04 | IntersectionObserverのrootMarginは200px | E-01 (519-521行目), E-03 | ○ |
| C-05 | 開発モードではビューポートプリフェッチは無効 | E-01 (541-543行目) | ○ |
| C-06 | prefetched Setで重複排除される | E-01 (131行目, 157-176行目) | ○ |
| C-07 | 修飾キー押下時はブラウザデフォルト動作に委ねる | E-01 (190-201行目, 219-225行目) | ○ |
| C-08 | isLocalURLでローカルURL判定を行う | E-01 (151-153行目, 227-237行目) | ○ |
| C-09 | Pages RouterとApp Routerの分岐はbeforePopStateで判定 | E-01 (258行目) | ○ |
| C-10 | legacyBehaviorはReact.cloneElementで子要素に注入 | E-01 (689行目) | ○ |
| C-11 | onNavigateコールバックでナビゲーション防止が可能 | E-01 (242-253行目) | ○ |
| C-12 | ホバー時は優先度付き(priority: true)プリフェッチを実行 | E-01 (624-629行目) | ○ |
| C-13 | タッチ開始時もプリフェッチを実行 | E-01 (631-656行目) | ○ |
| C-14 | resolveHrefは動的ルートの補間を行う | E-02 (104-123行目) | ○ |
| C-15 | プリフェッチキーはhref+as+localeで構成 | E-01 (167行目) | ○ |
| C-16 | legacyBehaviorは非推奨で将来削除予定 | E-01 (682-688行目) | ○ |
| C-17 | LinkStatusContextでpending状態を管理 | E-01 (700-711行目) | ○ |
| C-18 | addBasePathでbasePathを付加 | E-01 (677行目) | ○ |
| C-19 | addLocaleでロケールを付加 | E-01 (677行目) | ○ |
| C-20 | useLinkStatusはApp Router専用でpending状態を返す | E-01 (700-711行目) | △ |

## 4) 不足情報（Unknown / Missing）
- useLinkStatusの具体的な利用シーンとApp Routerでのpending状態の詳細な動作仕様
  - 候補：App Routerのナビゲーション実装 / React Transition API統合部分

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フローはソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] hrefの解決ロジック（resolveHref）が正しく記述されているか
- [ ] プリフェッチの動作条件（開発/本番、ビューポート検出）が正確か
- [ ] Pages Router / App Router両方の分岐が網羅されているか
