---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：52-next/navigation

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **NavigationPromisesContextの詳細仕様**：開発モードでのSuspense DevTools連携の具体的な動作について根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/components/navigation.ts` - フック実装本体（302行）
- E-02: `packages/next/src/api/navigation.ts` - エントリーポイント（1行）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | useRouterはAppRouterContextから取得 | E-01 (147行目) | ○ |
| C-02 | useRouterはcontext nullでエラースロー | E-01 (148-150行目) | ○ |
| C-03 | usePathnameはPathnameContextから取得 | E-01 (108行目) | ○ |
| C-04 | useSearchParamsはReadonlyURLSearchParamsを返す | E-01 (64-72行目) | ○ |
| C-05 | useSearchParamsはuseMemoでメモ化 | E-01 (64行目) | ○ |
| C-06 | useParamsはPathParamsContextから取得 | E-01 (176行目) | ○ |
| C-07 | useSelectedLayoutSegmentsはLayoutRouterContextを使用 | E-01 (220行目) | ○ |
| C-08 | useSelectedLayoutSegmentはuseSelectedLayoutSegmentsを内部で呼び出す | E-01 (265行目) | ○ |
| C-09 | parallelRouteKeyのデフォルトは'children' | E-01 (216行目, 261行目) | ○ |
| C-10 | サーバーサイドでuseDynamicRouteParamsが呼び出される | E-01 (21-33行目, 104行目) | ○ |
| C-11 | redirect/permanentRedirect等を再エクスポート | E-01 (294-301行目) | ○ |
| C-12 | unstable_isUnrecognizedActionErrorもエクスポート | E-01 (285行目) | ○ |
| C-13 | ReadonlyURLSearchParamsもエクスポート | E-01 (291行目) | ○ |
| C-14 | 開発モードでNavigationPromisesContextと連携 | E-01 (75-80行目, 111-116行目) | ○ |
| C-15 | Pages Routerではnullが返される可能性 | E-01 (62-63行目, 106-107行目) | ○ |
| C-16 | NavigationPromisesContextの完全な仕様 | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- NavigationPromisesContextの定義と、selectedLayoutSegmentPromises/selectedLayoutSegmentsPromisesの生成元
  - 候補：app-router.tsx / hooks-client-context.shared-runtime.ts

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 各フックの実装はシンプルなContext参照であり、ソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各フックの戻り値の型が正確か
- [ ] サーバーサイドでの動的レンダリング追跡が正しく記述されているか
- [ ] 再エクスポートされるAPIの一覧が完全か
