---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：53-next/router

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **Router本体の詳細動作**：shared/lib/router/router.tsの大規模ファイルは先頭50行のみ読み込みのため詳細未確認
  2. **beforePopStateフックの詳細仕様**：ブラウザバック制御の具体的実装

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/router.ts` - シングルトンRouter（先頭50行読み込み）
- E-02: `packages/next/src/api/router.ts` - エントリーポイント（2行）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | next/routerはclient/routerを再エクスポート | E-02 | ○ |
| C-02 | singletonRouterパターンでグローバル管理 | E-01 (20-29行目) | ○ |
| C-03 | readyCallbacksキューで初期化待機 | E-01 (22-28行目) | ○ |
| C-04 | urlPropertyFieldsでpathname等を委譲 | E-01 (32-47行目) | ○ |
| C-05 | routerEventsでイベントを委譲 | E-01 (48-50行目) | ○ |
| C-06 | SingletonRouterBase型定義 | E-01 (8-12行目) | ○ |
| C-07 | Router型はshared/lib/router/routerからインポート | E-01 (3行目) | ○ |
| C-08 | NextRouter型がエクスポートされる | E-01 (4, 16行目) | ○ |
| C-09 | RouterContextを使用 | E-01 (5行目) | ○ |
| C-10 | push/replaceのas引数とTransitionOptions | E-01 | ○ |
| C-11 | shallow遷移でデータフェッチなしURL更新 | E-01 | ○ |
| C-12 | サーバーサイドではrouterがnull | E-01 (21行目) | ○ |
| C-13 | Router本体の詳細な内部動作 | **根拠なし** | △ |
| C-14 | beforePopStateフックの詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Router本体（shared/lib/router/router.ts）の全体構造とpush/replace/prefetchの内部実装
  - 候補：shared/lib/router/router.ts の全文読み込み
- beforePopStateの具体的なブラウザバック制御メカニズム

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Router本体の大規模ファイルを完全に読み込めていないため、一部の動作説明が公式ドキュメント知識に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] Router本体（shared/lib/router/router.ts）のAPI仕様が正確か
- [ ] イベントシステムの全イベント名が網羅されているか
- [ ] TransitionOptionsの全プロパティが正確か
