---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-next/form（Form）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全主張が根拠ありのため、重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/form.tsx` - Formコンポーネント本体（169行）
- E-02: `packages/next/src/client/form-shared.tsx` - 共有型定義・ユーティリティ（181行）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FormはforwardRefで定義 | E-01 (18行目) | ○ |
| C-02 | action stringでナビゲーションフォーム判定 | E-01 (25行目) | ○ |
| C-03 | Pages Routerでprefetchは未サポート | E-01 (36-40行目) | ○ |
| C-04 | DISALLOWED_FORM_PROPSの検出と削除 | E-01 (55-62行目), E-02 (3行目) | ○ |
| C-05 | addBasePathでbasePath付加 | E-01 (68行目) | ○ |
| C-06 | onSubmitコールバック実行とdefaultPrevented確認 | E-01 (106-113行目) | ○ |
| C-07 | hasUnsupportedSubmitterAttributesでsubmitterチェック | E-01 (130-131行目), E-02 (133-173行目) | ○ |
| C-08 | hasReactClientActionAttributesでjavascript:検出 | E-01 (135-136行目), E-02 (175-180行目) | ○ |
| C-09 | createFormSubmitDestinationUrlでURL生成 | E-01 (152行目), E-02 (51-101行目) | ○ |
| C-10 | event.preventDefaultでネイティブ送信防止 | E-01 (155行目) | ○ |
| C-11 | router[method]でナビゲーション実行 | E-01 (168行目) | ○ |
| C-12 | FormDataをURLSearchParamsに変換 | E-02 (80-99行目) | ○ |
| C-13 | actionのクエリパラメータは上書きされる | E-02 (68-78行目) | ○ |
| C-14 | ファイル入力はファイル名のみ送信 | E-02 (82-95行目) | ○ |
| C-15 | submitterのformAction属性でaction上書き | E-01 (143-149行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] App Router版のForm実装との差異が正しく認識されているか
- [ ] HTML標準フォーム仕様との整合性が正確か
