---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：55-redirect / permanentRedirect

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Server Actionsでの303レスポンス変換**：エラーハンドリング側での変換ロジックは未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/components/redirect.ts` - redirect/permanentRedirect関数（98行）
- E-02: `packages/next/src/client/components/redirect-error.ts` - RedirectError型（43行）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | redirect関数はnever型で必ずスロー | E-01 (42, 45行目) | ○ |
| C-02 | permanentRedirectもnever型 | E-01 (63, 64行目) | ○ |
| C-03 | Server ActionsデフォルトでpushType | E-01 (43行目) | ○ |
| C-04 | actionAsyncStorageでServer Actions判定 | E-01 (9-14行目) | ○ |
| C-05 | redirectは307 TemporaryRedirect | E-01 (45行目) | ○ |
| C-06 | permanentRedirectは308 PermanentRedirect | E-01 (64行目) | ○ |
| C-07 | digestフォーマットはセミコロン区切り | E-01 (22行目) | ○ |
| C-08 | REDIRECT_ERROR_CODEは'NEXT_REDIRECT' | E-02 (3行目) | ○ |
| C-09 | RedirectTypeは'push'または'replace' | E-02 (5行目) | ○ |
| C-10 | isRedirectErrorでdigestを検証 | E-02 (18-42行目) | ○ |
| C-11 | getURLFromRedirectErrorでURLを抽出 | E-01 (75-81行目) | ○ |
| C-12 | getRedirectTypeFromErrorでタイプ抽出 | E-01 (83-89行目) | ○ |
| C-13 | getRedirectStatusCodeFromErrorでステータス抽出 | E-01 (91-97行目) | ○ |
| C-14 | URLにセミコロンが含まれる場合のスライス処理 | E-01 (80行目) | ○ |
| C-15 | permanentRedirectのデフォルトtypeは'replace' | E-01 (62行目) | ○ |
| C-16 | Server Actionsでの303レスポンス変換 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- エラーハンドリング側（app-render等）でのRedirectErrorからHTTPレスポンスへの変換ロジック
  - 候補：src/server/app-render/ 内のレンダリング処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - redirect/permanentRedirect自体の動作はソースコードから完全に確認済み。HTTPレスポンス変換は別コンポーネントの責務。

## 6) レビュアーチェックリスト（最小）
- [ ] digestフォーマットが正確に記述されているか
- [ ] Server Actions内でのデフォルトtypeが正確か
- [ ] ステータスコードの対応が正確か
