---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 12
  claims_without_evidence: 3
confidence_derived: 0.80
---

# 根拠レポート：56-Segment Cache

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：12 / 15、根拠なし：3
- 優先レビュー（高）
  1. **LRUキャッシュの具体的なサイズ上限**：lru.tsの全体は未読み込みのため詳細未確認
  2. **スケジューラの優先度管理の詳細**：scheduler.tsの先頭部分のみ確認
  3. **ステールタイムの具体値**：STATIC_STALETIME_MS/DYNAMIC_STALETIME_MSの定義元未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/components/segment-cache/prefetch.ts` - プリフェッチエントリーポイント（48行）
- E-02: `packages/next/src/client/components/segment-cache/cache.ts` - メインキャッシュ（先頭100行）
- E-03: `packages/next/src/shared/lib/segment-cache/segment-value-encoding.ts` - セグメントキーエンコーディング（95行）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | prefetch関数がエントリーポイント | E-01 (27-47行目) | ○ |
| C-02 | createPrefetchURLでURL検証 | E-01 (34-37行目) | ○ |
| C-03 | createCacheKeyでキャッシュキー生成 | E-01 (39行目) | ○ |
| C-04 | schedulePrefetchTaskでスケジューラ登録 | E-01 (40-46行目) | ○ |
| C-05 | onInvalidateコールバックで無効化通知 | E-01 (18-26行目, 32行目) | ○ |
| C-06 | セグメントキーのファイルシステム安全エンコード | E-03 (77-88行目) | ○ |
| C-07 | PAGE_SEGMENT_KEYの特別処理 | E-03 (18-29行目) | ○ |
| C-08 | 動的パラメータの$paramType$name形式 | E-03 (42-47行目) | ○ |
| C-09 | children以外の並列ルートは@プレフィックス | E-03 (63-67行目) | ○ |
| C-10 | convertSegmentPathToStaticExportFilename | E-03 (90-94行目) | ○ |
| C-11 | RSCヘッダーを使用したフェッチ | E-02 (17-24行目, インポート) | ○ |
| C-12 | VaryParamsによるダイナミックパラメータ管理 | E-02 (12-13行目, インポート) | ○ |
| C-13 | LRUキャッシュの具体的なサイズ上限 | **根拠なし** | △ |
| C-14 | スケジューラの優先度管理の詳細 | **根拠なし** | △ |
| C-15 | ステールタイムの具体値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- lru.tsの完全な実装（キャッシュサイズ上限、エビクション戦略）
  - 候補：packages/next/src/client/components/segment-cache/lru.ts
- scheduler.tsの完全な実装（優先度キューの動作）
  - 候補：packages/next/src/client/components/segment-cache/scheduler.ts
- STATIC_STALETIME_MS/DYNAMIC_STALETIME_MSの定義値
  - 候補：packages/next/src/client/components/router-reducer/reducers/navigate-reducer.ts

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 大規模なキャッシュ実装の詳細は一部未確認だが、全体構造は正確に把握

## 6) レビュアーチェックリスト（最小）
- [ ] LRUキャッシュのサイズ上限が正確か
- [ ] ステールタイムの具体値が正確か
- [ ] スケジューラの優先度管理が正確か
