---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：57-next/image（Image）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **getImgPropsの完全なロジック**：別ファイル（get-img-props.ts）のため詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/image-component.tsx` - Imageコンポーネント（435行、全行読み込み）
- E-02: `packages/next/src/shared/lib/image-config.ts` - 画像設定（参照のみ）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ImageはforwardRefで定義 | E-01 (358行目) | ○ |
| C-02 | RouterContextでApp/Pages判定 | E-01 (360行目) | ○ |
| C-03 | ImageConfigContextで設定取得 | E-01 (364行目) | ○ |
| C-04 | getImgPropsで画像属性計算 | E-01 (402-407行目) | ○ |
| C-05 | ImageElementで実際のimg要素レンダリング | E-01 (183-308行目) | ○ |
| C-06 | handleLoadingで読み込み完了処理 | E-01 (62-167行目) | ○ |
| C-07 | img.decode()で非同期デコード | E-01 (76行目) | ○ |
| C-08 | data-loaded-srcで重複防止 | E-01 (72-75行目) | ○ |
| C-09 | fill時のdata-nimg='fill' | E-01 (269行目) | ○ |
| C-10 | parent positionの検証（開発モード） | E-01 (136-145行目) | ○ |
| C-11 | sizes推奨の検証（開発モード） | E-01 (121-133行目) | ○ |
| C-12 | ImagePreloadの分岐（App/Pages） | E-01 (310-351行目) | ○ |
| C-13 | ReactDOM.preload使用（App Router） | E-01 (326-328行目) | ○ |
| C-14 | src属性をsrcSetの後に配置 | E-01 (278-280行目) | ○ |
| C-15 | loading属性をsrcの前に配置 | E-01 (265行目) | ○ |
| C-16 | getDynamicPropsでfetchPriority切替 | E-01 (169-181行目) | ○ |
| C-17 | onError時にsetShowAltText(true) | E-01 (296行目) | ○ |
| C-18 | getImgPropsの完全なsrcSet生成ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- get-img-props.tsの全実装（srcSet生成、width/height計算の詳細ロジック）
  - 候補：packages/next/src/shared/lib/get-img-props.ts

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンポーネント本体は全行確認済み、ロジック分離部分のみ未確認

## 6) レビュアーチェックリスト（最小）
- [ ] getImgPropsのsrcSet生成ロジックが正確か
- [ ] 開発モードの全バリデーションが網羅されているか
- [ ] ImagePreloadの分岐が正確か
