---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：58-Image Optimizer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **実際のsharpリサイズ処理の詳細**：500行目以降の最適化処理本体は未読み込み
  2. **IncrementalCacheとの統合詳細**：ImageOptimizerCacheクラスのコンストラクタ以降未読み込み

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/image-optimizer.ts` - Image Optimizer（先頭500行読み込み）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CACHE_VERSIONは4 | E-01 (56行目) | ○ |
| C-02 | BLUR_IMG_SIZE=8, BLUR_QUALITY=70 | E-01 (59-60行目) | ○ |
| C-03 | BYPASS_TYPESにSVG,ICO,ICNS,BMP,JXL,HEIC | E-01 (58行目) | ○ |
| C-04 | ANIMATABLE_TYPESにWEBP,PNG,GIF | E-01 (57行目) | ○ |
| C-05 | getSharpで動的読み込みと並列度制御 | E-01 (64-88行目) | ○ |
| C-06 | 開発モードでは並列度を4分の1に制限 | E-01 (74行目) | ○ |
| C-07 | validateParamsでurl,w,qの完全バリデーション | E-01 (322-482行目) | ○ |
| C-08 | URL長さ3072文字制限 | E-01 (354-356行目) | ○ |
| C-09 | 再帰的URL防止（/_next/image検出） | E-01 (370-377行目) | ○ |
| C-10 | localPatterns/remotePatterns照合 | E-01 (378-398行目) | ○ |
| C-11 | domains非推奨警告 | E-01 (342-346行目) | ○ |
| C-12 | detectContentTypeのマジックナンバー解析 | E-01 (167-314行目) | ○ |
| C-13 | getCacheKeyはSHA256ハッシュ | E-01 (113-123行目, 484-496行目) | ○ |
| C-14 | writeToCacheDirのファイル名形式 | E-01 (141-160行目) | ○ |
| C-15 | minimumCacheTTLデフォルト14400 | E-01 (333行目) | ○ |
| C-16 | getSupportedMimeTypeでAcceptヘッダー解析 | E-01 (108-111行目) | ○ |
| C-17 | ImageUpstream型定義 | E-01 (101-106行目) | ○ |
| C-18 | qualities設定のサポート | E-01 (454-464行目) | ○ |
| C-19 | sharp最適化処理の完全な詳細 | **根拠なし** | △ |
| C-20 | IncrementalCacheとの統合詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- image-optimizer.tsの500行目以降（sharp処理本体、画像フェッチ、レスポンス生成）
  - 候補：同ファイルの後半部分
- ImageOptimizerCacheクラスのget/set/constructor実装
  - 候補：同ファイルの498行目以降

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 1214行の大規模ファイルの前半のみ確認。後半の最適化処理本体は未確認。

## 6) レビュアーチェックリスト（最小）
- [ ] sharp処理のリサイズ・フォーマット変換の詳細が正確か
- [ ] キャッシュの読み込み・書き込みのライフサイクルが正確か
- [ ] IncrementalCacheとの統合が正しく記述されているか
