---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：59-next/font

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Webpack/Turbopackローダー統合の詳細**：ビルドシステムとの統合部分は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/font/src/google/loader.ts` - Google Fontsローダー（196行）
- E-02: `packages/font/src/local/loader.ts` - ローカルフォントローダー（114行）
- E-03: `packages/font/src/types.ts` - 型定義（12行）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Google FontsローダーがCSS取得→フォントDL→セルフホスティング | E-01 (74-157行目) | ○ |
| C-02 | cssCache/fontCacheで重複フェッチ防止 | E-01 (13-14行目, 80-92行目, 109-121行目) | ○ |
| C-03 | キャッシュは1回目set、2回目delete | E-01 (88-92行目) | ○ |
| C-04 | findFontFilesInCssでCSS内URL抽出 | E-01 (101-104行目) | ○ |
| C-05 | escapeStringRegexpでURL置換 | E-01 (152-157行目, 17-26行目) | ○ |
| C-06 | 開発モードでフェッチ失敗時フォールバックCSS生成 | E-01 (164-193行目) | ○ |
| C-07 | getFallbackFontOverrideMetricsで事前計算メトリクス | E-01 (60-61行目) | ○ |
| C-08 | ローカルフォントはvalidateLocalFontFunctionCallで検証 | E-02 (23-33行目) | ○ |
| C-09 | ローカルフォントはfontFromBufferでメタデータ解析 | E-02 (1-7行目, 52-53行目) | ○ |
| C-10 | pickFontFileForFallbackGenerationでフォールバック用ファイル選択 | E-02 (95行目) | ○ |
| C-11 | getFallbackMetricsFromFontFileでメトリクス計算 | E-02 (97-99行目) | ○ |
| C-12 | declarations内のカスタムfont-family対応 | E-02 (58-60行目, 67行目) | ○ |
| C-13 | NextFont型: className + style | E-03 (5-8行目) | ○ |
| C-14 | NextFontWithVariable型: NextFont + variable | E-03 (10-12行目) | ○ |
| C-15 | CssVariable型: --で始まる文字列 | E-03 (1行目) | ○ |
| C-16 | 画面No.2でフォントpreload/preconnect | E-05 (9行目) | ○ |
| C-17 | adjustFontFallback 'Times New Roman'でserif判定 | E-02 (99行目) | ○ |
| C-18 | Webpack/Turbopackローダーとの統合詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- next/fontのWebpack/Turbopackローダー統合（next-font-loaderの実装）
  - 候補：packages/next/src/build/webpack/loaders/next-font-loader/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ローダー本体の実装は完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Google Fontsからのフェッチフローが正確か
- [ ] フォールバックメトリクスの計算方法が正確か
- [ ] ローカルフォントの@font-face CSS生成が正確か
