---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-next/script（Script）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全主張が根拠ありのため、重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/script.tsx` - Scriptコンポーネント（386行、全行読み込み）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ScriptCacheはMapでsrc→loadPromise | E-01 (10行目, 82-88行目, 138行目) | ○ |
| C-02 | LoadCacheはSetでid/srcの読み込み追跡 | E-01 (11行目, 77-78行目, 97行目) | ○ |
| C-03 | strategyのデフォルトはafterInteractive | E-01 (69行目, 205行目) | ○ |
| C-04 | loadScript内でscript要素生成とDOM追加 | E-01 (100行目, 154行目) | ○ |
| C-05 | setAttributesFromPropsでDOM属性設定 | E-01 (141行目) | ○ |
| C-06 | worker戦略でtype='text/partytown' | E-01 (143-145行目) | ○ |
| C-07 | data-nscript属性で戦略を記録 | E-01 (147行目) | ○ |
| C-08 | lazyOnloadはwindow.load後requestIdleCallback | E-01 (159-165行目, 168-176行目) | ○ |
| C-09 | hasOnReadyEffectCalledで2重実行防止 | E-01 (244-256行目) | ○ |
| C-10 | hasLoadScriptEffectCalledで2重実行防止 | E-01 (258-270行目) | ○ |
| C-11 | beforeInteractiveでupdateScripts呼び出し | E-01 (273-285行目) | ○ |
| C-12 | App Router: ReactDOM.preload使用 | E-01 (339-349行目, 365-376行目) | ○ |
| C-13 | App Router: self.__next_s配列にpush | E-01 (330-335行目, 354-360行目) | ○ |
| C-14 | insertStylesheetsでReactDOM.preinit | E-01 (35-38行目) | ○ |
| C-15 | Pages RouterではDOM link要素生成 | E-01 (47-58行目) | ○ |
| C-16 | onLoad/onError Promise管理 | E-01 (102-117行目) | ○ |
| C-17 | インラインスクリプトは即座afterLoad | E-01 (119-132行目) | ○ |
| C-18 | __nextScriptプロパティ設定 | E-01 (383行目) | ○ |
| C-19 | addBeforeInteractiveToCacheの存在 | E-01 (178-187行目) | ○ |
| C-20 | nonce処理（props優先、context fallback） | E-01 (216行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコード全体を確認済み、全主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 4つの読み込み戦略の動作タイミングが正確か
- [ ] App Router / Pages Router両方の分岐が網羅されているか
- [ ] ScriptCache/LoadCacheの重複防止ロジックが正確か
