---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：61-next/dynamic

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18: リトライ仕様**：DynamicOptionsLoadingPropsにretryが含まれるがデフォルト実装がない旨の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/dynamic.tsx`
- E-02: `packages/next/src/shared/lib/lazy-dynamic/loadable.tsx`
- E-03: `packages/next/src/shared/lib/lazy-dynamic/types.ts`
- E-04: `packages/next/src/shared/lib/lazy-dynamic/bailout-to-csr.ts`
- E-05: `packages/next/src/shared/lib/lazy-dynamic/dynamic-bailout-to-csr.tsx`
- E-06: `packages/next/src/shared/lib/lazy-dynamic/preload-chunks.tsx`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dynamic()はReact.lazyとSuspenseを基盤とする | E-02（1行目: import lazy, Suspense） | ○ |
| C-02 | ssr: false指定時にサーバーサイドレンダリングをバイパスする | E-01（140-145行目: ssr === false判定） | ○ |
| C-03 | dynamicOptionsはPromise、関数、オブジェクトの3形式をサポート | E-01（111-119行目: instanceof Promise, typeof function, typeof object） | ○ |
| C-04 | convertModuleがdefault export形式に正規化する | E-01（34-36行目）, E-02（9-26行目） | ○ |
| C-05 | loadableGeneratedはBabelプラグインが挿入する | E-01（130行目: コメント "coming from build/babel/plugins/react-loadable-plugin.js"） | ○ |
| C-06 | SSR無効時にBailoutToCSRErrorをthrowする | E-04（5-11行目）, E-05（16-17行目） | ○ |
| C-07 | BailoutToCSRErrorのdigestは'BAILOUT_TO_CLIENT_SIDE_RENDERING' | E-04（2行目, 6行目） | ○ |
| C-08 | PreloadChunksがreactLoadableManifestからCSSを抽出する | E-06（28-35行目） | ○ |
| C-09 | CSSにはprecedence="dynamic"のlinkタグを使用する | E-06（52-61行目） | ○ |
| C-10 | スクリプトのプリロードはfetchPriority: 'low'で行われる | E-06（65-68行目） | ○ |
| C-11 | nonceをサポートしCSPに対応する | E-06（60行目, 68行目: workStore.nonce） | ○ |
| C-12 | デプロイメントIDをクエリパラメータとして付与する | E-06（41行目: getDeploymentIdQueryOrEmptyString） | ○ |
| C-13 | デフォルトのloadingコンポーネントはpastDelay前はnullを返す | E-01（88行目: if (!pastDelay) return null） | ○ |
| C-14 | Suspenseバウンダリはssr無効またはloading指定時に付与される | E-02（52行目: !opts.ssr \|\| !!opts.loading） | ○ |
| C-15 | noSSR関数はサーバーサイドでLoadingコンポーネントのみを返す | E-01（66-70行目） | ○ |
| C-16 | LoadableComponentのdisplayNameは'LoadableComponent' | E-02（72行目） | ○ |
| C-17 | PreloadChunksはクライアントサイドでnullを返す | E-06（15-17行目: typeof window !== 'undefined'時return null） | ○ |
| C-18 | デフォルト実装ではリトライ機構は提供されていない | - | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：DynamicOptionsLoadingPropsの型定義にretryプロパティが存在することは確認できるが（E-03: 6行目）、実際にretry関数が渡されるかどうかは内部実装の確認が必要
  - 候補：react-loadableの元実装 / Next.jsのBabelプラグイン / Webpackプラグイン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードと直接対応する主張がほとんどであり、信頼性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] dynamic()の3形式のオーバーロード（Promise/Function/Object）が正しく記述されているか
- [ ] BailoutToCSRの動作メカニズムが正確か
- [ ] PreloadChunksのCSS先読みロジックが正確か
- [ ] リトライ仕様の記述が実際の実装と整合しているか
