---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：62-Bundle Analyzer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし。全ての主張に根拠がある。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next-bundle-analyzer/index.js`
- E-02: `packages/next-bundle-analyzer/index.d.ts`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | enabled=falseの場合はnextConfigをそのまま返却する | E-01（4-6行目） | ○ |
| C-02 | Turbopackビルド時は警告を表示し分析レポートを生成しない | E-01（7-15行目: process.env.TURBOPACK判定） | ○ |
| C-03 | analyzerModeに応じて出力ファイル拡張子が変わる | E-01（17行目: analyzerMode === 'json' ? '.json' : '.html'） | ○ |
| C-04 | BundleAnalyzerPluginを使用している | E-01（21行目: require('webpack-bundle-analyzer')） | ○ |
| C-05 | デフォルトのanalyzerModeは'static' | E-01（24行目: analyzerMode \|\| 'static'） | ○ |
| C-06 | clientコンパイラのレポートは./analyze/client{ext}に出力 | E-01（28行目: reportFilename条件分岐） | ○ |
| C-07 | nodejsコンパイラのレポートパスが正しい | E-01（29-31行目: ../../analyze/nodejs） | ○ |
| C-08 | 既存のwebpack設定関数があれば呼び出す | E-01（35-37行目: typeof nextConfig.webpack === 'function'判定） | ○ |
| C-09 | Higher-Order Functionパターンである | E-02（13行目: (config?: NextConfig) => NextConfig） | ○ |
| C-10 | enabledのデフォルト値はtrue | E-01（2行目: enabled = true） | ○ |
| C-11 | logLevelオプションをサポートする | E-01（25行目）, E-02（11行目） | ○ |
| C-12 | openAnalyzerオプションをサポートする | E-01（26行目）, E-02（5行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パッケージが41行と小規模であり、全コードを直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] レポートファイルパスの計算式（相対パス）が正確か
- [ ] Turbopack非互換の警告メッセージ内容が最新か
