---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 10
  claims_without_evidence: 4
confidence_derived: 0.71
---

# 根拠レポート：63-コード分割

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.71**
  - 根拠あり：10 / 14、根拠なし：4
- 優先レビュー（高）
  1. **C-07: SplitChunksデフォルト設定値**：具体的なminSize/maxSize値の確認が必要
  2. **C-10: App Routerセグメント単位分割**：Turbopackでの分割動作の詳細確認が必要
  3. **C-12: CSS自動分割の詳細**：CSS抽出プラグインの設定確認が必要
  4. **C-14: SRI対応**：SRI設定の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack-config.ts`（参照確認済み・splitChunks設定部分）
- E-02: `packages/next/src/build/entries.ts`（参照確認済み・エントリーポイント生成部分）
- E-03: `packages/next/src/build/index.ts`（参照確認済み・ビルドプロセス）
- E-04: Next.js公式ドキュメント（コード分割に関する説明）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページ単位で自動的にJavaScriptチャンクを分離する | E-01, E-02 | ○ |
| C-02 | Webpack SplitChunksPluginを利用している | E-01 | ○ |
| C-03 | 各ページのエントリーポイントから依存グラフを辿る | E-02, E-03 | ○ |
| C-04 | フレームワークチャンク（react等）を分離する | E-01（cacheGroups.framework設定） | ○ |
| C-05 | 共有モジュールをcommonsチャンクに分離する | E-01（cacheGroups.commons設定） | ○ |
| C-06 | ランタイムチャンクを分離する | E-01（runtimeChunk設定） | ○ |
| C-07 | minSize/maxSize制約に基づくチャンク結合/分離 | **根拠不足** | △ |
| C-08 | ビルドマニフェストにページとチャンクの対応を記録 | E-01（BuildManifestPlugin参照） | ○ |
| C-09 | .next/static/chunks/に出力される | E-03 | ○ |
| C-10 | App Routerではルートセグメント単位の分割が行われる | **根拠不足** | △ |
| C-11 | chunks: 'all'設定を使用 | E-01 | ○ |
| C-12 | CSS自動分割の詳細 | **根拠不足** | △ |
| C-13 | minChunks: 2で共有モジュールを判定 | E-01 | ○ |
| C-14 | SRIが有効な場合にハッシュが付与される | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-07: SplitChunksPluginの具体的なminSize/maxSize値はwebpack-config.tsの詳細な読み込みが必要
  - 候補：webpack-config.tsのsplitChunks設定部分
- C-10: App RouterのTurbopackでのセグメント分割実装の詳細
  - 候補：turbopack/ディレクトリの設定ファイル
- C-12: CSS抽出・分割の具体的な設定
  - 候補：mini-css-extract-pluginの設定部分
- C-14: SRI設定の詳細な実装箇所
  - 候補：next.config.jsのexperimental.sri設定

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - コード分割はバンドラー（Webpack/Turbopack/Rspack）の内部挙動に依存するため、全ての動作を直接ソースコードから確認することが困難

## 6) レビュアーチェックリスト（最小）
- [ ] SplitChunksPluginの設定値（minSize等）が実際のwebpack-config.tsと一致しているか
- [ ] App Routerのセグメント単位分割の記述が正確か
- [ ] CSS分割の動作記述が正確か
- [ ] Turbopack/Rspackでの分割動作の記述が正確か
