---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 13
  claims_with_evidence: 9
  claims_without_evidence: 4
confidence_derived: 0.69
---

# 根拠レポート：64-ツリーシェイキング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.69**
  - 根拠あり：9 / 13、根拠なし：4
- 優先レビュー（高）
  1. **C-05: optimizePackageImportsの詳細動作**：バレルファイルローダーの具体的な変換ロジック確認が必要
  2. **C-08: Server Componentsのツリーシェイキング**：RSC固有の除去ロジック確認が必要
  3. **C-10: concatenateModules設定**：実際の設定値確認が必要
  4. **C-13: Turbopack/Rspackでの動作**：Turbopack固有のツリーシェイキング実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack-config.ts`（参照確認済み・optimization設定部分）
- E-02: `packages/next/src/build/index.ts`（参照確認済み・ビルドプロセス）
- E-03: Webpackドキュメント（usedExports、sideEffectsの仕様）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ESモジュールの静的解析に基づき未使用エクスポートを判定する | E-01, E-03 | ○ |
| C-02 | sideEffectsフラグでモジュール全体の除去判定を行う | E-01, E-03 | ○ |
| C-03 | プロダクションモードでのみ完全なツリーシェイキングが実行される | E-01（mode: 'production'設定） | ○ |
| C-04 | TerserPlugin/SWC Minifyで最終的なDead Code Eliminationを行う | E-01（minimizer設定） | ○ |
| C-05 | optimizePackageImportsでバレルファイルを最適化する | **根拠不足** | △ |
| C-06 | CommonJSモジュールはツリーシェイキングの対象外 | E-03 | ○ |
| C-07 | usedExports最適化が有効化されている | E-01 | ○ |
| C-08 | Server Componentsでサーバー専用コードがクライアントバンドルから除去される | **根拠不足** | △ |
| C-09 | sideEffects最適化が有効化されている | E-01 | ○ |
| C-10 | concatenateModules（Scope Hoisting）が有効 | **根拠不足** | △ |
| C-11 | バンドルサイズ削減の効果がある | E-03（Webpack公式仕様） | ○ |
| C-12 | package.jsonのsideEffectsフィールドを参照する | E-03 | ○ |
| C-13 | Turbopack/Rspackでも同等の最適化が行われる | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-05: next-barrel-loader.tsの具体的な変換ロジックの詳細確認
  - 候補：`packages/next/src/build/webpack/loaders/next-barrel-loader.ts`
- C-08: React Server Componentsのクライアントバンドル除去メカニズム
  - 候補：`packages/next/src/build/webpack/plugins/flight-client-entry-plugin.ts`
- C-10: concatenateModulesの実際の設定値
  - 候補：`packages/next/src/build/webpack-config.ts`のoptimization設定
- C-13: Turbopack/Rspackのツリーシェイキング実装
  - 候補：`turbopack/`ディレクトリ、`packages/next-rspack/`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ツリーシェイキングはバンドラーの内部最適化に依存するため、Next.js固有のソースコードからすべてを確認することが困難

## 6) レビュアーチェックリスト（最小）
- [ ] Webpack optimization設定の値がwebpack-config.tsの実際の設定と一致しているか
- [ ] optimizePackageImportsの動作説明が正確か
- [ ] Server Componentsのツリーシェイキング記述が正確か
- [ ] Turbopack/Rspackでの動作記述が正確か
