---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：65-Node.jsサーバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **C-14: stale-while-revalidateパターン**：ISR再生成の詳細動作確認が必要
  2. **C-16: ストリーミングレスポンス**：ストリーミング対応の実装詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/next-server.ts`（173-320行目を中心に確認）
- E-02: `packages/next/src/server/base-server.ts`（1-80行目を確認）
- E-03: `packages/next/src/server/load-components.ts`
- E-04: `packages/next/src/server/response-cache/`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextNodeServerはBaseServerを継承する | E-01（173行目: extends BaseServer） | ○ |
| C-02 | Node.js固有の型（NodeNextRequest/NodeNextResponse）を使用する | E-01（173-176行目: ジェネリクス指定） | ○ |
| C-03 | プロダクション環境でnext startで起動される | E-01, 機能一覧CSV | ○ |
| C-04 | SRI有効時にintegrityハッシュを使用する | E-01（206行目: this.sriEnabled） | ○ |
| C-05 | imageResponseCacheを初期化する | E-01（221行目: new ResponseCache） | ○ |
| C-06 | preloadEntriesOnStartで全エントリーをプリロード | E-01（224-230行目, 286-318行目） | ○ |
| C-07 | 動的ルートの正規表現を構築する | E-01（232-245行目: getRouteRegex, getRouteMatcher） | ○ |
| C-08 | MiddlewareMatcherをWeakMapでキャッシュする | E-01（149-171行目: MiddlewareMatcherCache） | ○ |
| C-09 | middlewareManifestPathを設定する | E-01（259-262行目） | ○ |
| C-10 | prepare()を非同期で開始する | E-01（268-272行目） | ○ |
| C-11 | testProxy環境でテストAPIをインターセプトする | E-01（251-257行目） | ○ |
| C-12 | removeUncaughtErrorAndRejectionListeners設定を処理する | E-01（280-283行目） | ○ |
| C-13 | マニフェストベースのルーティングを行う | E-01（PAGES_MANIFEST, APP_PATHS_MANIFEST等のimport） | ○ |
| C-14 | ISRでstale-while-revalidateパターンを使用する | **根拠不足** | △ |
| C-15 | isExperimentalCompile時にstaticEnvを設定する | E-01（276-278行目） | ○ |
| C-16 | ストリーミング対応でメモリ効率を確保する | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: ISRのstale-while-revalidateパターンの実装詳細
  - 候補：`packages/next/src/server/response-cache/`、`packages/next/src/server/lib/incremental-cache/`
- C-16: ストリーミングレスポンスの実装詳細
  - 候補：`packages/next/src/server/stream-utils/`、`packages/next/src/server/pipe-readable.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンストラクタの初期化処理を直接確認済み。リクエスト処理の全体フローはBaseServerの複雑な処理チェーンに依存する

## 6) レビュアーチェックリスト（最小）
- [ ] BaseServerの継承関係とオーバーライドメソッドが正確に記述されているか
- [ ] コンストラクタの初期化処理が漏れなく記述されているか
- [ ] ISRキャッシュの動作記述が正確か
- [ ] エラーハンドリングの記述が正確か
