---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：66-開発サーバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **C-15: interception routes rewrites自動生成**：実装箇所の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/next-dev-server.ts`（1-199行目を中心に確認）
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts`
- E-03: `packages/next/src/server/next-server.ts`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DevServerはNextNodeServer（Server）を継承する | E-01（116行目: extends Server） | ○ |
| C-02 | dev: trueで初期化する | E-01（178行目: super({ ...options, dev: true })） | ○ |
| C-03 | Error.stackTraceLimitを50に設定する | E-01（176行目） | ○ |
| C-04 | 静的パスキャッシュはLRUCache（5MB）で管理される | E-01（185-192行目: new LRUCache(5 * 1024 * 1024)） | ○ |
| C-05 | 静的パスワーカーはnumWorkers: 1で実行される | E-01（151行目） | ○ |
| C-06 | NODE_OPTIONSからinspectフラグを除外する | E-01（160行目: getFormattedNodeOptionsWithoutInspect） | ○ |
| C-07 | pagesDir/appDirを検出する | E-01（194行目: findPagesDir） | ○ |
| C-08 | renderOpts.dev = trueを設定する | E-01（183行目） | ○ |
| C-09 | ErrorDebugにReactDevOverlayを設定する | E-01（184行目） | ○ |
| C-10 | ReactDevOverlayは遅延ロードされる | E-01（87-95行目: require条件付き） | ○ |
| C-11 | serverComponentsHmrCache有効時にHMRキャッシュを初期化する | E-01（198行目: nextConfig.experimental.serverComponentsHmrCache） | ○ |
| C-12 | workerThreadsを設定で制御可能 | E-01（152行目: nextConfig.experimental.workerThreads） | ○ |
| C-13 | DevBundlerServiceをbundlerServiceとして保持する | E-01（131行目, 180行目） | ○ |
| C-14 | DetachedPromiseでready状態を管理する | E-01（124行目: new DetachedPromise<void>()） | ○ |
| C-15 | interception routes rewritesの自動生成を含む | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: interception routes rewritesの自動生成の実装箇所
  - 候補：`packages/next/src/lib/generate-interception-routes-rewrites.ts`（importは確認済み、E-01 69行目）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンストラクタとクラス定義を直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] DevServerの継承関係が正確に記述されているか
- [ ] コンストラクタの初期化順序が正確か
- [ ] 静的パスワーカーの設定が正確か
- [ ] interception routes rewritesの自動生成記述が正確か
