---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：68-Edge Runtime

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **C-17: コールドスタート性能**：Edge RuntimeのNode.js比較での性能優位性は一般的知識に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/web/adapter.ts`（1-78行目）
- E-02: `packages/next/src/server/web/sandbox/sandbox.ts`（1-80行目）
- E-03: `packages/next/src/server/web/sandbox/context.ts`（1-80行目）
- E-04: `packages/next/src/server/web/edge-route-module-wrapper.ts`（1-80行目）
- E-05: `packages/next/src/server/web/types.ts`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | moduleContextsマップでモジュールコンテキストをキャッシュする | E-03（56行目） | ○ |
| C-02 | clearAllModuleContextsでリソースクリーンアップする | E-03（63-68行目） | ○ |
| C-03 | clearModuleContextでHMR時にモジュールを個別クリーンアップする | E-03（78-80行目） | ○ |
| C-04 | withTaggedErrorsで開発モード時にedge-serverタグを付与する | E-02（48-69行目） | ○ |
| C-05 | NextRequestHintがrequest/respondWith/waitUntilでPageSignatureErrorをthrow | E-01（40-63行目） | ○ |
| C-06 | FORBIDDEN_HEADERSでcontent-length等を除去する | E-02（23-27行目） | ○ |
| C-07 | EdgeRouteModuleWrapperのwrap()がadapter()を通じてハンドラを実行する | E-04（51-68行目） | ○ |
| C-08 | EdgeRouteModuleWrapperはprivateコンストラクタを持つ | E-04（37行目） | ○ |
| C-09 | RouteMatcher.isDynamicで動的ルート判定を行う | E-04（75行目） | ○ |
| C-10 | intervalsManager/timeoutsManagerでタイマーを管理する | E-03（23行目, 64-65行目） | ○ |
| C-11 | pendingModuleCachesで並行初期化を管理する | E-03（58行目） | ○ |
| C-12 | EdgeRuntimeをnext/dist/compiled/edge-runtimeからインポートする | E-03（12行目） | ○ |
| C-13 | AsyncLocalStorageをサポートする | E-03（7行目: import） | ○ |
| C-14 | 開発モードでgetServerErrorとdecorateServerErrorを使用する | E-03（39-49行目） | ○ |
| C-15 | AdapterOptions型にhandler、page、request等が含まれる | E-01（71-78行目） | ○ |
| C-16 | headersGetterでOpenTelemetry互換のヘッダー取得を提供する | E-01（66-69行目） | ○ |
| C-17 | Node.jsランタイムと比較してコールドスタートが高速 | **根拠不足**（一般的知識） | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: コールドスタート性能のベンチマーク根拠
  - 候補：Edge Runtimeの公式ドキュメント / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なソースファイルを直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Edge RuntimeのAPI制限リスト（EDGE_UNSUPPORTED_NODE_APIS）が正確か
- [ ] サンドボックスのセキュリティ制約が正確に記述されているか
- [ ] NextRequestHintの不正アクセス時のエラー処理が正確か
- [ ] モジュールコンテキストキャッシュの動作が正確か
