---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：69-Hot Module Replacement

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **C-15: React Fast Refresh統合の詳細**：Fast Refreshの具体的な統合箇所の確認が必要
  2. **C-16: WebSocket接続のlocalhost限定**：WebSocketバインドアドレスの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts`（全282行）
- E-02: `packages/next/src/server/dev/hot-reloader-webpack.ts`（1-100行目）
- E-03: `packages/next/src/server/dev/hot-reloader-turbopack.ts`（1-100行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Webpack、Turbopack、Rspackの3種類のバンドラーに対応 | E-01, E-02, E-03（各ファイルの存在） | ○ |
| C-02 | NextJsHotReloaderInterfaceで共通APIを定義 | E-01（219-281行目） | ○ |
| C-03 | HMR_MESSAGE_SENT_TO_BROWSERでメッセージ種別を定義 | E-01（18-44行目） | ○ |
| C-04 | JSONメッセージとバイナリメッセージの2形式がある | E-01（42-43行目: 数値型=バイナリ、文字列型=JSON） | ○ |
| C-05 | SyncMessageにhash、errors、warnings、versionInfoを含む | E-01（75-85行目） | ○ |
| C-06 | BuildingMessageは単純なtype指定のみ | E-01（63-65行目） | ○ |
| C-07 | serverComponentChangesメッセージが定義されている | E-01（110-113行目） | ○ |
| C-08 | middlewareChangesメッセージが定義されている | E-01（115-117行目） | ○ |
| C-09 | sendToLegacyClients()でレガシークライアント分離 | E-01（237-238行目） | ○ |
| C-10 | ensurePage()でページのコンパイルを保証 | E-01（265-279行目） | ○ |
| C-11 | invalidate()でコンパイル無効化と再ビルドを実行 | E-01（259-263行目） | ○ |
| C-12 | setCacheStatus()とsetReactDebugChannel()が定義されている | E-01（239-244行目） | ○ |
| C-13 | Webpack HMRでWebpackHotMiddlewareとon-demand-entry-handlerを使用 | E-02（15行目, 48-53行目: import） | ○ |
| C-14 | Turbopack HMRでchangeSubscriptionsを使用 | E-03（47-48行目: import type） | ○ |
| C-15 | React Fast Refresh統合でコンポーネント状態を保持 | **根拠不足** | △ |
| C-16 | WebSocket接続はlocalhostに限定される | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: React Fast Refreshの統合箇所
  - 候補：`packages/next/src/client/dev/` 内のクライアントサイド実装
- C-16: WebSocketバインドアドレスの設定
  - 候補：hot-reloader-webpack.tsまたはhot-reloader-turbopack.tsのWebSocket初期化部分

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型定義とインターフェースを直接確認済み。各バンドラー実装の詳細は大規模で全容の確認は困難

## 6) レビュアーチェックリスト（最小）
- [ ] HMRメッセージ種別が最新のソースコードと一致しているか
- [ ] NextJsHotReloaderInterfaceのメソッド一覧が正確か
- [ ] React Fast Refresh統合の記述が正確か
- [ ] 3種類のバンドラー実装の役割記述が正確か
