---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：70-On-Demand Entry Handler

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18: MCP統合の詳細**：handleErrorStateResponse/handlePageMetadataResponseの具体的な動作確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/on-demand-entry-handler.ts`（全体を確認。特に100-643行目）
- E-02: `packages/next/src/server/dev/hot-reloader-webpack.ts`（48-53行目: import確認）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エントリーキーは{compiler}@{pageType}@{page}形式 | E-01（116-125行目: getEntryKey関数） | ○ |
| C-02 | ビルド状態はADDED→BUILDING→BUILTで遷移する | E-01（171-173行目: export const ADDED/BUILDING/BUILT） | ○ |
| C-03 | Entry型にabsolutePagePathとappPathsが含まれる | E-01（206-218行目） | ○ |
| C-04 | ChildEntry型にparentEntriesとabsoluteEntryFilePathが含まれる | E-01（220-231行目） | ○ |
| C-05 | entriesMapでエントリーを管理する | E-01（233-242行目） | ○ |
| C-06 | Invalidatorがbuilding/rebuildAgainを追跡する | E-01（272-326行目） | ○ |
| C-07 | ビルド中のinvalidateはrebuildAgainフラグを立てる | E-01（293-295行目） | ○ |
| C-08 | doneBuilding()でrebuildAgainがあれば再invalidate | E-01（312-320行目） | ○ |
| C-09 | disposeInactiveEntriesでmaxInactiveAge超過エントリーを破棄 | E-01（328-371行目） | ○ |
| C-10 | ミドルウェア/Instrumentationは自動破棄対象外 | E-01（344-348行目: isMiddlewareFilename/isInstrumentationHookFilename判定） | ○ |
| C-11 | 最終アクセスページは非活性判定対象外 | E-01（361-365行目: lastClientAccessPages判定） | ○ |
| C-12 | findPagePathDataでappDir→pagesDir→_errorの順に検索 | E-01（400-538行目） | ○ |
| C-13 | global-not-foundをnot-foundより優先してロード | E-01（450-457行目: isGlobalNotFoundEnabled判定） | ○ |
| C-14 | onDemandEntryHandler関数でInvalidatorを作成 | E-01（560-568行目） | ○ |
| C-15 | compiler.hooks.makeでビルド開始を追跡 | E-01（571-577行目） | ○ |
| C-16 | compiler.hooks.doneでビルド完了を処理 | E-01（604-610行目） | ○ |
| C-17 | multiCompiler.hooks.doneでエントリーステータスを更新 | E-01（612-643行目） | ○ |
| C-18 | MCP統合としてhandleErrorStateResponse等を含む | E-01（49-50行目: import確認）、**詳細確認不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: handleErrorStateResponse/handlePageMetadataResponseの具体的な実装と呼び出し箇所
  - 候補：`packages/next/src/server/mcp/tools/get-errors.ts`、`packages/next/src/server/mcp/tools/get-page-metadata.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なロジック（エントリー管理、Invalidator、findPagePathData）を直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] エントリーキーの計算式が正確か
- [ ] ビルド状態遷移（ADDED→BUILDING→BUILT）が正確か
- [ ] findPagePathDataの検索優先順位が正確か
- [ ] Invalidatorの並行ビルド制御ロジックが正確か
- [ ] disposeInactiveEntriesの自動破棄ルールが正確か
