---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：71-Middleware

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（数ミリ秒以内）**：具体的な数値の根拠がコード内に存在しない
  2. **config.matcher設定**：設定の詳細な仕組みはビルド時のプラグインコードで処理されるため、参照コードが限定的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/web/adapter.ts` - adapter()関数の実装
- E-02: `packages/next/src/server/web/types.ts` - 型定義（RequestData, FetchEventResult, NextMiddleware等）
- E-03: `packages/next/src/server/web/spec-extension/request.ts` - NextRequestクラス
- E-04: `packages/next/src/server/web/spec-extension/response.ts` - NextResponseクラス（redirect/rewrite/next静的メソッド）
- E-05: `packages/next/src/server/web/spec-extension/fetch-event.ts` - NextFetchEvent/FetchEvent
- E-06: `packages/next/src/server/web/sandbox/sandbox.ts` - Edge Runtimeサンドボックス
- E-07: `packages/next/src/server/web/utils.ts` - validateURL, toNodeOutgoingHttpHeaders等
- E-08: `packages/next/src/server/web/next-url.ts` - NextURLクラス
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.71の説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MiddlewareはEdge Runtimeベースで実行される | E-06 (sandbox.ts) | ○ |
| C-02 | リライト・リダイレクト・ヘッダー操作・レスポンス生成を行う | E-04 (response.ts: redirect/rewrite/next静的メソッド) | ○ |
| C-03 | middleware.tsファイルに定義される | E-01 (adapter.ts:253-256 isMiddleware判定) | ○ |
| C-04 | NextRequestとNextFetchEventが引数として渡される | E-01 (adapter.ts:323-325), E-02 (types.ts:67-70) | ○ |
| C-05 | リダイレクトステータスコードは301,302,303,307,308のみ | E-04 (response.ts:10 REDIRECTSセット) | ○ |
| C-06 | config.matcherでパスマッチングが可能 | E-09 (機能一覧.csv) | ○ |
| C-07 | adapter()がMiddleware実行の中核関数 | E-01 (adapter.ts:109-510) | ○ |
| C-08 | Flight headersはMiddlewareで上書き不可 | E-01 (adapter.ts:162-170, 487-503) | ○ |
| C-09 | RSC URLが正規化される | E-01 (adapter.ts:119) | ○ |
| C-10 | OpenTelemetryトレーシングでラップされる | E-01 (adapter.ts:266-268 MiddlewareSpan.execute) | ○ |
| C-11 | AsyncStorageコンテキスト内で実行される | E-01 (adapter.ts:320-327 workAsyncStorage.run) | ○ |
| C-12 | Middlewareはストリーミング不可 | E-01 (adapter.ts:329-335 コメント) | ○ |
| C-13 | NextMiddleware型はNextProxyに名称変更予定 | E-02 (types.ts:63-64 @deprecated, 72-80 NextProxy) | ○ |
| C-14 | waitUntilの2種類の実装（internal/external） | E-05 (fetch-event.ts:12-14) | ○ |
| C-15 | sandbox内でFORBIDDEN_HEADERSが除去される | E-06 (sandbox.ts:23-27, 146-148) | ○ |
| C-16 | 非推奨API呼び出し時にPageSignatureErrorがスローされる | E-05 (fetch-event.ts:76-91) | ○ |
| C-17 | パフォーマンスターゲットは数ミリ秒以内 | **根拠なし** | △ |
| C-18 | config.matcherの詳細なフィルタリング仕組み | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコードベースに記載がなく、ドキュメントやベンチマーク結果に基づく推定
  - 候補：Next.js公式ドキュメント / Vercelデプロイメントベンチマーク / Edge Runtimeパフォーマンス仕様
- config.matcherの詳細な処理はビルドプラグイン側（middleware-plugin.ts等）で行われており、今回の調査範囲外
  - 候補：`src/build/webpack/plugins/middleware-plugin.ts` / Next.js Middleware公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアロジック（adapter.ts）の記述は直接コード参照に基づいており正確
- 1: 中リスク - config.matcherの詳細仕様はビルド時プラグインコードの調査が必要
- 0: 低リスク - NextProxy名称変更の記述はコード内のJSDocから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] adapter.tsの処理フロー記述が実際のコードと一致しているか
- [ ] リダイレクトステータスコードの制限が正しいか（REDIRECTS Set確認）
- [ ] config.matcherの仕組みをビルドプラグイン側のコードと照合
- [ ] パフォーマンス要件の数値を公式ドキュメントと照合
- [ ] NextProxy名称変更の記述が最新の方針と一致しているか
