---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-NextRequest

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/web/spec-extension/request.ts` - NextRequestクラス実装（117行）
- E-02: `packages/next/src/server/web/spec-extension/cookies.ts` - RequestCookies再エクスポート
- E-03: `packages/next/src/server/web/next-url.ts` - NextURLクラス
- E-04: `packages/next/src/server/web/utils.ts` - validateURL関数
- E-05: `packages/next/src/server/web/adapter.ts` - NextRequestHintクラス
- E-06: `packages/next/src/server/web/error.ts` - エラークラス定義（推定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextRequestはWeb標準Requestを継承 | E-01 (request.ts:14 `extends Request`) | ○ |
| C-02 | cookiesプロパティはRequestCookiesを返す | E-01 (request.ts:46,76-78) | ○ |
| C-03 | nextUrlプロパティはNextURLを返す | E-01 (request.ts:41-44,80-82) | ○ |
| C-04 | urlプロパティは正規化済み文字列を返す | E-01 (request.ts:48-50,102-104) | ○ |
| C-05 | コンストラクタでvalidateURLが呼ばれる | E-01 (request.ts:26), E-04 | ○ |
| C-06 | Node.js環境でduplex:'half'が自動設定 | E-01 (request.ts:32-36) | ○ |
| C-07 | pageプロパティはRemovedPageErrorをスロー | E-01 (request.ts:89-91) | ○ |
| C-08 | uaプロパティはRemovedUAErrorをスロー | E-01 (request.ts:98-100) | ○ |
| C-09 | INTERNALSはSymbolで定義 | E-01 (request.ts:7) | ○ |
| C-10 | RequestInitがnextConfig等で拡張 | E-01 (request.ts:107-116) | ○ |
| C-11 | __NEXT_NO_MIDDLEWARE_URL_NORMALIZEでURL正規化スキップ | E-01 (request.ts:48-50) | ○ |
| C-12 | NextURLにheadersとnextConfigが渡される | E-01 (request.ts:41-44) | ○ |
| C-13 | NextRequestHintがNextRequestを継承 | E-05 (adapter.ts:40) | ○ |
| C-14 | edge-runtime.inspect.customシンボルによるカスタム表示 | E-01 (request.ts:54-74) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張がソースコードから直接確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - NextRequestクラスは比較的シンプルで117行のファイルに完結している

## 6) レビュアーチェックリスト（最小）
- [ ] NextRequestのコンストラクタ処理フローが正確か
- [ ] 非推奨プロパティ（page, ua）のエラー種別が正しいか
- [ ] RequestInit拡張のプロパティ一覧が網羅的か
