---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-headers()

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/request/headers.ts` - headers()関数実装（306行）
- E-02: `packages/next/src/server/web/spec-extension/adapters/headers.ts` - HeadersAdapter/ReadonlyHeaders（232行）
- E-03: `packages/next/src/api/headers.ts` - 公開API再エクスポート

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | headers()はPromise<ReadonlyHeaders>を返す | E-01 (headers.ts:40) | ○ |
| C-02 | headers()はDynamic APIで動的レンダリングを強制 | E-01 (headers.ts:135 trackDynamicDataInDynamicRender) | ○ |
| C-03 | ReadonlyHeadersはappend/set/deleteでエラースロー | E-02 (headers.ts:8-18,121-134 seal) | ○ |
| C-04 | after()内での使用は制限される | E-01 (headers.ts:46-54) | ○ |
| C-05 | forceStatic時は空ヘッダーを返却 | E-01 (headers.ts:56-61) | ○ |
| C-06 | cache内での使用はエラー | E-01 (headers.ts:66-71) | ○ |
| C-07 | unstable_cache内での使用はエラー | E-01 (headers.ts:73-76) | ○ |
| C-08 | prerenderでハンギングPromise生成 | E-01 (headers.ts:98-99, 163-180) | ○ |
| C-09 | prerender-pprでpostponeWithTracking | E-01 (headers.ts:105-114) | ○ |
| C-10 | prerender-legacyでthrowToInterruptStaticGeneration | E-01 (headers.ts:115-124) | ○ |
| C-11 | dynamicShouldErrorでStaticGenBailoutError | E-01 (headers.ts:90-94) | ○ |
| C-12 | CachedHeaders WeakMapでPromiseキャッシュ | E-01 (headers.ts:161) | ○ |
| C-13 | 開発モードで同期アクセス警告 | E-01 (headers.ts:141-148, 228-249) | ○ |
| C-14 | prerender-clientでInvariantError | E-01 (headers.ts:100-104) | ○ |
| C-15 | prerender-runtimeでdelayUntilRuntimeStage | E-01 (headers.ts:125-129) | ○ |
| C-16 | private-cacheで遅延なしヘッダー返却 | E-01 (headers.ts:130-133) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張がソースコードから直接確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - headers()関数は単一ファイルに完結し、分岐条件が明確

## 6) レビュアーチェックリスト（最小）
- [ ] WorkUnitStore種別ごとの分岐処理が正確に記述されているか
- [ ] エラーケース一覧が網羅的か
- [ ] 開発モード警告の仕組みの説明が正確か
