---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-cookies()

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/request/cookies.ts` - cookies()関数実装（304行）
- E-02: `packages/next/src/server/web/spec-extension/adapters/request-cookies.ts` - RequestCookiesAdapter/MutableRequestCookiesAdapter（238行）
- E-03: `packages/next/src/server/web/spec-extension/cookies.ts` - 再エクスポート

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cookies()はPromise<ReadonlyRequestCookies>を返す | E-01 (cookies.ts:33) | ○ |
| C-02 | cookies()はDynamic API | E-01 (cookies.ts:109 trackDynamicDataInDynamicRender) | ○ |
| C-03 | Server Actionsでmutable Cookiesを返却 | E-01 (cookies.ts:113), E-02 (request-cookies.ts:208-210) | ○ |
| C-04 | render/afterフェーズではset/deleteがエラー | E-02 (request-cookies.ts:219-226) | ○ |
| C-05 | after()内での使用は制限される | E-01 (cookies.ts:39-48) | ○ |
| C-06 | forceStatic時は空Cookiesを返却 | E-01 (cookies.ts:50-55) | ○ |
| C-07 | cache内での使用はエラー | E-01 (cookies.ts:66-71) | ○ |
| C-08 | dynamicShouldErrorでStaticGenBailoutError | E-01 (cookies.ts:57-61) | ○ |
| C-09 | prerenderでハンギングPromise生成 | E-01 (cookies.ts:77, 154-171) | ○ |
| C-10 | Cookie変更時にpathWasRevalidated設定 | E-02 (request-cookies.ts:120) | ○ |
| C-11 | SYMBOL_MODIFY_COOKIE_VALUESで変更追跡 | E-02 (request-cookies.ts:53,141-142) | ○ |
| C-12 | onUpdateCookiesでSet-Cookieヘッダー更新 | E-02 (request-cookies.ts:125-134) | ○ |
| C-13 | CachedCookies WeakMapでPromiseキャッシュ | E-01 (cookies.ts:149) | ○ |
| C-14 | 開発モードで同期アクセス警告 | E-01 (cookies.ts:126-127, 228-247) | ○ |
| C-15 | createEmptyCookies()で空Cookies生成 | E-01 (cookies.ts:144-146) | ○ |
| C-16 | areCookiesMutableInCurrentPhaseはphase==='action'で判定 | E-02 (request-cookies.ts:208-210) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - cookies()関数はheaders()と同様のパターンで実装されており、コードとの対応が明確

## 6) レビュアーチェックリスト（最小）
- [ ] Server Actions以外のフェーズでCookie書き込みエラーが発生することの確認
- [ ] pathWasRevalidated設定の影響範囲の確認
- [ ] MutableRequestCookiesAdapter.wrap()のProxy動作が正確に記述されているか
