---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：76-draftMode()

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/request/draft-mode.ts` - draftMode()関数・DraftModeクラス実装（249行）
- E-02: `packages/next/src/server/async-storage/draft-mode-provider.ts` - DraftModeProviderクラス（97行）
- E-03: `packages/next/src/api/headers.ts` - 再エクスポート

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | draftMode()はPromise<DraftMode>を返す | E-01 (draft-mode.ts:25) | ○ |
| C-02 | DraftModeにisEnabled, enable(), disable()がある | E-01 (draft-mode.ts:135,141,149) | ○ |
| C-03 | __prerender_bypass Cookieで判定 | E-02 (draft-mode-provider.ts:41) | ○ |
| C-04 | previewModeIdとの一致で有効判定 | E-02 (draft-mode-provider.ts:43-51) | ○ |
| C-05 | 開発モードではdevelopment-idでも有効 | E-02 (draft-mode-provider.ts:49-50) | ○ |
| C-06 | On-Demand Revalidate時は無効 | E-02 (draft-mode-provider.ts:37-39) | ○ |
| C-07 | enable()でCookie設定（httpOnly, secure等） | E-02 (draft-mode-provider.ts:62-77) | ○ |
| C-08 | disable()でCookie期限切れ設定 | E-02 (draft-mode-provider.ts:80-95) | ○ |
| C-09 | after()内でenable/disable禁止 | E-01 (draft-mode.ts:179-183) | ○ |
| C-10 | cache内でenable/disable禁止 | E-01 (draft-mode.ts:193-201) | ○ |
| C-11 | dynamicShouldErrorでStaticGenBailoutError | E-01 (draft-mode.ts:185-189) | ○ |
| C-12 | cache内でisEnabled読み取り可能 | E-01 (draft-mode.ts:46-57 getDraftModeProviderForCacheScope) | ○ |
| C-13 | prerender系では空DraftMode | E-01 (draft-mode.ts:61-66) | ○ |
| C-14 | CachedDraftModes WeakMapでキャッシュ | E-01 (draft-mode.ts:94) | ○ |
| C-15 | enable/disable時にtrackDynamicDraftMode | E-01 (draft-mode.ts:144,150) | ○ |
| C-16 | 開発モードでProxy経由の同期アクセス警告 | E-01 (draft-mode.ts:96-124) | ○ |
| C-17 | providerがnullの場合isEnabled=false | E-01 (draft-mode.ts:136-139) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - draftMode()の実装はコードから直接確認でき、ロジックが明確

## 6) レビュアーチェックリスト（最小）
- [ ] DraftModeProvider初期化時のCookie検証ロジックが正確か
- [ ] enable()/disable()のCookie属性設定が正確か
- [ ] cache内でのisEnabled読み取り動作の記述が正確か
