---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：77-after()

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/after/after.ts` - after()関数（22行）
- E-02: `packages/next/src/server/after/after-context.ts` - AfterContextクラス（159行）
- E-03: `packages/next/src/server/after/awaiter.ts` - AwaiterMulti/AwaiterOnceクラス（72行）
- E-04: `packages/next/src/server/after/run-with-after.ts` - AfterRunnerクラス（34行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | after()はvoidを返す | E-01 (after.ts:9) | ○ |
| C-02 | Promise/関数の2種類を受け付ける | E-02 (after-context.ts:40-52) | ○ |
| C-03 | 不正な引数でエラースロー | E-02 (after-context.ts:51) | ○ |
| C-04 | waitUntil不可でエラー | E-02 (after-context.ts:41-43,57-59,154-158) | ○ |
| C-05 | リクエストスコープ外でエラー | E-01 (after.ts:12-17) | ○ |
| C-06 | Promiseはwaitに直接登録 | E-02 (after-context.ts:44-46) | ○ |
| C-07 | 関数はaddCallbackでキュー登録 | E-02 (after-context.ts:49) | ○ |
| C-08 | bindSnapshotでALSキャプチャ | E-02 (after-context.ts:87-99) | ○ |
| C-09 | afterTaskAsyncStorageでラップ | E-02 (after-context.ts:92-93) | ○ |
| C-10 | PromiseQueueで順次実行 | E-02 (after-context.ts:27,36,101,122-123) | ○ |
| C-11 | onClose後に実行開始 | E-02 (after-context.ts:104-107) | ○ |
| C-12 | phase='after'に変更 | E-02 (after-context.ts:112-114) | ○ |
| C-13 | withExecuteRevalidates内で実行 | E-02 (after-context.ts:121-124) | ○ |
| C-14 | エラーはreportTaskErrorで処理 | E-02 (after-context.ts:45,96,127-151) | ○ |
| C-15 | onTaskErrorコールバックに通知 | E-02 (after-context.ts:136-149) | ○ |
| C-16 | rootTaskSpawnPhaseでネスト対応 | E-02 (after-context.ts:72-74) | ○ |
| C-17 | AwaiterMultiは再帰的waitUntil対応 | E-03 (awaiter.ts:32-38) | ○ |
| C-18 | AwaiterOnceはawait後のwaitUntilでエラー | E-03 (awaiter.ts:54-60) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - after()の実装は明確で、全ファイルが参照可能

## 6) レビュアーチェックリスト（最小）
- [ ] AfterContext.addCallback()のbindSnapshot/afterTaskAsyncStorage動作が正確か
- [ ] PromiseQueueの順次実行動作の記述が正確か
- [ ] エラーハンドリングの防御的実装の記述が完全か
