---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-userAgent()

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/web/spec-extension/user-agent.ts` - userAgent()実装（45行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | userAgent()はheadersからUser-Agent取得 | E-01 (user-agent.ts:43) | ○ |
| C-02 | ua-parser-jsで文字列パース | E-01 (user-agent.ts:1,37) | ○ |
| C-03 | isBot()は正規表現でボット判定 | E-01 (user-agent.ts:29-33) | ○ |
| C-04 | ケースインセンシティブ正規表現（/i） | E-01 (user-agent.ts:30-32) | ○ |
| C-05 | UserAgentインターフェースの構造 | E-01 (user-agent.ts:3-27) | ○ |
| C-06 | undefinedの場合isBot=false | E-01 (user-agent.ts:38) | ○ |
| C-07 | 3つのエクスポート関数 | E-01 (user-agent.ts:29,35,42) | ○ |
| C-08 | GPTBotが検出対象に含まれる | E-01 (user-agent.ts:32) | ○ |
| C-09 | 全体45行のコンパクトなファイル | E-01 | ○ |
| C-10 | NextRequestのua代替として提供 | E-01 (NextRequestのRemovedUAErrorから推定), 機能一覧.csv | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 45行のシンプルな実装で、全ロジックが直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ボット検出対象のリストが最新か（新しいボットの追加漏れ確認）
- [ ] UserAgentインターフェースの構造がua-parser-jsの出力と一致するか
