---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：79-NextURL

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/web/next-url.ts` - NextURLクラス実装（284行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextURLはURL APIを拡張する | E-01 (next-url.ts:34 クラス定義) | ○ |
| C-02 | basePath, locale, buildIdの解析 | E-01 (next-url.ts:76-104 analyze()) | ○ |
| C-03 | parseURL()でlocalhost正規化 | E-01 (next-url.ts:22-30) | ○ |
| C-04 | getNextPathnameInfo()でパス分析 | E-01 (next-url.ts:77-81) | ○ |
| C-05 | detectDomainLocale()でドメインロケール検出 | E-01 (next-url.ts:87-92) | ○ |
| C-06 | locale setterで無効ロケールはTypeError | E-01 (next-url.ts:136-146) | ○ |
| C-07 | basePath setterで先頭スラッシュ自動付与 | E-01 (next-url.ts:251-253) | ○ |
| C-08 | hrefはformatPathname + search + hash | E-01 (next-url.ts:192-196) | ○ |
| C-09 | formatNextPathnameInfo()でパス再構築 | E-01 (next-url.ts:106-117) | ○ |
| C-10 | forceLocaleオプションでデフォルトロケール制御 | E-01 (next-url.ts:110-111) | ○ |
| C-11 | [Internal] Symbolで内部状態隠蔽 | E-01 (next-url.ts:32) | ○ |
| C-12 | clone()で新インスタンス生成 | E-01 (next-url.ts:280-282) | ○ |
| C-13 | searchParamsはURLのsearchParamsを委譲 | E-01 (next-url.ts:156-158) | ○ |
| C-14 | Optionsインターフェースの定義 | E-01 (next-url.ts:10-20) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - NextURLクラスは単一ファイルに完結し、ロジックが明確

## 6) レビュアーチェックリスト（最小）
- [ ] analyze()のパス分析結果がgetNextPathnameInfoと一致するか
- [ ] formatNextPathnameInfo()の再構築結果が正確か
- [ ] ドメインロケール検出の動作が正確か
