---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 8
  claims_with_evidence: 7
  claims_without_evidence: 1
confidence_derived: 0.88
---

# 根拠レポート：80-URLPattern

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：7 / 8、根拠なし：1
- 優先レビュー（高）
  1. **URLPatternの詳細仕様（test/exec等のメソッド）**：Web標準仕様であり、Next.jsコードベース内に詳細実装は存在しない

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/web/spec-extension/url-pattern.ts` - URLPattern再エクスポート（5行）
- E-02: `packages/next/src/server/web/spec-extension/request.ts` - NextRequest.page非推奨メッセージ
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.80

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グローバルURLPatternの可用性チェック | E-01 (url-pattern.ts:1-3) | ○ |
| C-02 | undefinedの場合はundefinedをエクスポート | E-01 (url-pattern.ts:3) | ○ |
| C-03 | @ts-expect-errorコメントの存在 | E-01 (url-pattern.ts:2) | ○ |
| C-04 | 5行のシンプルなモジュール | E-01 | ○ |
| C-05 | NextRequest.pageの代替として推奨 | E-02 (request.ts:86-87) | ○ |
| C-06 | named exportとしてURLPatternをエクスポート | E-01 (url-pattern.ts:5) | ○ |
| C-07 | Edge Runtimeでネイティブサポート | E-03 (機能一覧.csv) | ○ |
| C-08 | test(), exec()メソッドの動作詳細 | **根拠なし**（Web標準仕様） | △ |

## 4) 不足情報（Unknown / Missing）
- URLPatternのtest()/exec()メソッドの詳細動作はWeb標準仕様（URL Pattern API）に依存しており、Next.jsコードベース内に実装は存在しない
  - 候補：URL Pattern API仕様（https://urlpattern.spec.whatwg.org/） / MDN Web Docs

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Next.jsの実装は5行の再エクスポートのみで確認が容易
- 1: 中リスク - URLPatternの詳細仕様はWeb標準依存であり、ランタイム環境ごとの実装差異が存在する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] URLPatternがEdge Runtime以外の環境で利用可能か確認
- [ ] test()/exec()の動作説明がWeb標準仕様と一致するか
- [ ] Node.js環境でのURLPatternサポート状況を確認
