---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：81-next.config.js / next.config.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **設定ファイル優先度（ts > js > mjs）**：CONFIG_FILES定数の定義を直接確認していない
  2. **Node.js v22.10.0のネイティブTS対応**：バージョン要件の正確性を要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/config.ts` - 設定読み込みメインモジュール
- E-02: `packages/next/src/server/config-shared.ts` - 設定型定義・デフォルト値
- E-03: `packages/next/src/build/next-config-ts/transpile-config.ts` - TypeScript設定トランスパイル
- E-04: `packages/next/src/build/next-config-ts/require-hook.ts` - requireフック
- E-05: `packages/next/src/lib/static-env.ts` - 静的環境変数処理
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 設定ファイルの検索はfindUpで行われる | E-01 (4行目 import findUp) | ○ |
| C-02 | .tsファイルはSWCでトランスパイルされる | E-03 (139-191行目) | ○ |
| C-03 | Zodスキーマによるバリデーションが行われる | E-01 (52-96行目 normalizeNextConfigZodErrors) | ○ |
| C-04 | distDirに"public"は使用不可 | E-01 (310-314行目) | ○ |
| C-05 | basePathは"/"で始まり"/"で終わらない | E-01 (477-494行目) | ○ |
| C-06 | 非推奨オプションのチェックはcheckDeprecationsで行われる | E-01 (125-208行目) | ○ |
| C-07 | assignDefaultsAndValidateでデフォルト値がマージされる | E-01 (274行目) | ○ |
| C-08 | NextConfigComplete型はRequired<Omit<NextConfig, 'configFile'>> | E-02 (19行目) | ○ |
| C-09 | ExperimentalConfig型が実験的機能の設定を定義 | E-02 (324行目) | ○ |
| C-10 | I18NConfig型が国際化設定を定義 | E-02 (36-41行目) | ○ |
| C-11 | TypeScriptConfig型にignoreBuildErrorsとtsconfigPathがある | E-02 (50-55行目) | ○ |
| C-12 | Node.jsネイティブTS対応はv22.10.0以降 | E-03 (150-157行目 コメント参照) | ○ |
| C-13 | transpileConfigでSWCバインディングのtransformを使用 | E-03 (208-210行目) | ○ |
| C-14 | NODE_*や__*プレフィックスのenv設定キーは禁止 | E-05 (10行目 正規表現) | ○ |
| C-15 | images設定のバリデーションエラーは致命的エラー | E-01 (63-66行目) | ○ |
| C-16 | 設定ファイル優先度はts > js > mjs | **根拠なし** | △ |
| C-17 | warnOptionHasBeenMovedOutOfExperimentalで移行処理が行われる | E-01 (210-238行目) | ○ |
| C-18 | pageExtensionsは空配列不可 | E-01 (332-335行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 設定ファイル優先度の正確な順序はCONFIG_FILES定数の定義を直接確認する必要がある
  - 候補：`packages/next/src/shared/lib/constants.ts` のCONFIG_FILES定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードに基づいた記述であり、信頼性は高い
- 1: 中リスク - CONFIG_FILESの優先度順序は定数定義を直接確認すべき

## 6) レビュアーチェックリスト（最小）
- [ ] CONFIG_FILES定数の定義でファイル優先度の順序を確認
- [ ] loadConfig関数の実際のシグネチャと処理フローの一致を確認
- [ ] Zodスキーマの実際の定義箇所を確認
