---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：83-環境変数

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **.envファイル優先度の正確な順序**：@next/envパッケージの内部実装を未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/lib/static-env.ts` - 静的環境変数処理
- E-02: `packages/next/src/server/config.ts` - loadEnvConfigのインポート
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NEXT_PUBLIC_プレフィックス変数がクライアントサイドに公開される | E-01 (23-35行目) | ○ |
| C-02 | NODE_*、__*プレフィックスは禁止 | E-01 (10行目 正規表現) | ○ |
| C-03 | NEXT_RUNTIMEキーは禁止 | E-01 (11行目) | ○ |
| C-04 | getStaticEnvで環境変数がマージされる | E-01 (56-66行目) | ○ |
| C-05 | NEXT_DEPLOYMENT_IDが自動注入される | E-01 (63行目) | ○ |
| C-06 | NEXT_PUBLIC_変数はアルファベット順にソートされる | E-01 (33行目 sort) | ○ |
| C-07 | populateStaticEnvでprocess.envに反映される | E-01 (68-82行目) | ○ |
| C-08 | loadEnvConfigは@next/envから読み込まれる | E-02 (26行目) | ○ |
| C-09 | getNextConfigEnvでconfig.envから変数を収集 | E-01 (40-54行目) | ○ |
| C-10 | errorIfEnvConflictedで禁止キーチェック | E-01 (6-18行目) | ○ |
| C-11 | getNextPublicEnvironmentVariablesでNEXT_PUBLIC_変数を収集 | E-01 (23-35行目) | ○ |
| C-12 | .envファイル優先度は.env.local > .env.{mode} > .env | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- .envファイルの読み込み優先度は@next/envパッケージの内部実装に依存
  - 候補：`packages/next-env/` パッケージの実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - static-env.tsの処理は完全にソースコードで確認済み
- 1: 中リスク - @next/envの.envファイル優先度は外部ドキュメント参照が必要

## 6) レビュアーチェックリスト（最小）
- [ ] @next/envパッケージの.envファイル読み込み順序を確認
- [ ] define-env.tsのDefinePlugin統合を確認
