---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-カスタムルート（Rewrites/Redirects/Headers）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/lib/load-custom-routes.ts` - カスタムルート処理のメインモジュール（全行読了）
- E-02: `packages/next/src/server/config.ts` - 設定読み込みにおけるカスタムルート統合
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Rewrite型にsource, destination, basePath, locale, has, missingフィールド | E-01 (22-39行目) | ○ |
| C-02 | Header型にsource, headers, basePath, locale, has, missingフィールド | E-01 (41-53行目) | ○ |
| C-03 | Redirect型はpermanentとstatusCodeが排他的 | E-01 (56-78行目) | ○ |
| C-04 | checkCustomRoutesで全バリデーションを実行 | E-01 (146-487行目) | ○ |
| C-05 | sourceは"/"で始まる必要がある | E-01 (293行目) | ○ |
| C-06 | source正規表現は4096文字以下 | E-01 (332-334行目) | ○ |
| C-07 | has/missing条件のバリデーションが行われる | E-01 (228-281行目) | ○ |
| C-08 | processRoutesでi18n/basePath正規化 | E-01 (499-581行目) | ○ |
| C-09 | loadRedirectsで設定関数を実行 | E-01 (583-599行目) | ○ |
| C-10 | loadRewritesでassetPrefix自動リライトを追加 | E-01 (601-628行目) | ○ |
| C-11 | Rewritesはオブジェクト形式でbeforeFiles/afterFiles/fallbackに分類可能 | E-01 (489-497行目) | ○ |
| C-12 | basePath=falseのリライトはhttpまたはhttps始まりのdestination必須 | E-01 (196-210行目) | ○ |
| C-13 | バリデーションエラー時はprocess.exit(1) | E-01 (447-486行目) | ○ |
| C-14 | destinationパラメータの整合性チェック | E-01 (362-427行目) | ○ |
| C-15 | i18n有効時にロケールプレフィックス付きルートが生成される | E-01 (536-568行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードを網羅的に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Router Serverでの実際のルート適用処理を確認
- [ ] output: "export"時の警告動作を確認
