---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-国際化（i18n）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/i18n/normalize-locale-path.ts` - ロケールパス正規化（全行読了）
- E-02: `packages/next/src/shared/lib/i18n/detect-domain-locale.ts` - ドメインロケール検出（全行読了）
- E-03: `packages/next/src/shared/lib/i18n/get-locale-redirect.ts` - ロケールリダイレクト（全行読了）
- E-04: `packages/next/src/server/config-shared.ts` - I18NConfig型定義
- E-05: `packages/next/src/server/config.ts` - i18n設定検証

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | I18NConfigにdefaultLocale, locales, domains, localeDetectionが定義 | E-04 (36-41行目) | ○ |
| C-02 | DomainLocaleにdefaultLocale, domain, http, localesが定義 | E-04 (43-48行目) | ○ |
| C-03 | normalizeLocalePathでパスからロケール検出 | E-01 (22-61行目) | ○ |
| C-04 | WeakMapキャッシュでロケール小文字変換を最適化 | E-01 (11, 30-33行目) | ○ |
| C-05 | ロケール照合は大文字小文字非依存 | E-01 (47行目 toLowerCase) | ○ |
| C-06 | detectDomainLocaleでhostname/detectedLocaleからドメイン設定検出 | E-02 (3-25行目) | ○ |
| C-07 | ドメインからポート番号を除去して照合 | E-02 (16行目 split) | ○ |
| C-08 | getLocaleRedirectでリダイレクト判定 | E-03 (70-117行目) | ○ |
| C-09 | ロケール検出優先順位: pathLocale > domainLocale > cookie > Accept-Language > defaultLocale | E-03 (47-53行目) | ○ |
| C-10 | localeDetection !== falseかつルートパスの場合のみリダイレクト | E-03 (78-81行目) | ○ |
| C-11 | ドメインリダイレクト時にHTTP/HTTPSプロトコル制御 | E-03 (102行目) | ○ |
| C-12 | NEXT_LOCALEクッキーからロケール取得 | E-03 (22-32行目) | ○ |
| C-13 | App Routerプロジェクトでi18n使用時に警告 | E-05 (187-197行目) | ○ |
| C-14 | output: "export"とi18nの併用でエラー | E-05 (438-443行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - i18n関連のすべてのソースファイルを全行読了

## 6) レビュアーチェックリスト（最小）
- [ ] Router Serverでの実際のi18nルーティング統合箇所を確認
- [ ] accept-header.tsのAccept-Language解析ロジックを確認
