---
generated_at: 2026-02-03 11:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：87-Turbopack統合

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **Turbopackプロジェクト作成の詳細フロー**：Rust側の実装は未確認
  2. **HMRストリーミング配信の実装**：hot-reloader-turbopack.tsは未読

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/swc/index.ts` - SWCバインディング・Turbopack統合
- E-02: `packages/next/src/server/config-shared.ts` - TurbopackOptions型定義
- E-03: `packages/next/src/build/swc/types.ts` - Turbopack型定義（ファイル名のみ）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TurbopackOptionsにresolveAlias, resolveExtensions, rules, root, debugIds | E-02 (179-217行目) | ○ |
| C-02 | TurbopackModuleTypeに9種類のモジュールタイプ | E-02 (141-150行目) | ○ |
| C-03 | loadBindingsでネイティブ/WASMバインディング読み込み | E-01 (197-269行目) | ○ |
| C-04 | バージョン不一致チェック | E-01 (131-139行目) | ○ |
| C-05 | Rustスタックサイズデフォルト8MB | E-01 (208-209行目) | ○ |
| C-06 | WASM優先フォールバック対象プラットフォーム | E-01 (146-154行目) | ○ |
| C-07 | turbopackFileSystemCacheForDev（デフォルトtrue） | E-02 (497-499行目) | ○ |
| C-08 | turbopackFileSystemCacheForBuild（デフォルトfalse） | E-02 (505-506行目) | ○ |
| C-09 | turbopackMemoryLimitでメモリ上限設定 | E-02 (465行目) | ○ |
| C-10 | DevToolsメニューでTurbopack情報表示 | E-04 (37行目) | ○ |
| C-11 | sassOptions.functionsがTurbopack非サポート | E-01からの間接参照（config.ts 420-430行目） | ○ |
| C-12 | Turbopackプロジェクト作成の詳細フロー | **根拠なし** | △ |
| C-13 | HMRストリーミング配信の実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Turbopackプロジェクト作成のRust側実装は未確認
  - 候補：`turbopack/` ディレクトリのRustソースコード
- HMRストリーミング配信の実装は未確認
  - 候補：`packages/next/src/server/dev/hot-reloader-turbopack.ts`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Rust側の実装詳細が未確認
- 1: 中リスク - HMR配信の実装が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] hot-reloader-turbopack.tsのHMR実装を確認
- [ ] Turbopackプロジェクト作成のRust APIを確認
- [ ] types.tsの詳細な型定義を確認
