---
generated_at: 2026-02-03 11:10:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：88-Rspack統合

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **getWebpackBundler関数の詳細**：実装ファイルを直接読了していない

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next-rspack/index.js` - withRspack関数の実装（全行読了）
- E-02: `packages/next-rspack/index.d.ts` - 型定義（全行読了）
- E-03: `packages/next-rspack/package.json` - パッケージ定義（全行読了）
- E-04: `packages/next/src/build/webpack-config.ts` - Rspack関連インポート
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | withRspack関数がNextConfig -> NextConfigの関数型 | E-02 (3-4行目) | ○ |
| C-02 | NEXT_RSPACK設定済みチェックで二重呼び出し防止 | E-01 (3-5行目) | ○ |
| C-03 | TURBOPACK=autoチェックでバンドラ排他制御 | E-01 (7行目) | ○ |
| C-04 | TURBOPACK環境変数を削除 | E-01 (8行目) | ○ |
| C-05 | RSPACK_CONFIG_VALIDATE=loose-silentに設定 | E-01 (9行目) | ○ |
| C-06 | NEXT_RSPACK=trueに設定 | E-01 (10行目) | ○ |
| C-07 | --turbopack/--webpackフラグとの排他エラー | E-01 (12-18行目) | ○ |
| C-08 | @next/rspack-coreバージョン1.0.2が依存 | E-03 (10行目) | ○ |
| C-09 | RspackFlightClientEntryPluginのインポート | E-04 (53行目) | ○ |
| C-10 | getReactRefreshLoaderでRspack対応 | E-04 (181-184行目) | ○ |
| C-11 | getWebpackBundler関数の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- getWebpackBundlerの実装詳細を未確認
  - 候補：`packages/next/src/shared/lib/get-webpack-bundler.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - withRspackの実装は全行読了済みでシンプル
- 1: 中リスク - Webpack設定内でのRspack切り替え詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] get-webpack-bundler.tsの実装を確認
- [ ] get-rspack.tsの実装を確認
- [ ] Rspack固有プラグインの動作を確認
