---
generated_at: 2026-02-03 11:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：89-SWC（コンパイラ）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **next-swc-loader.tsの詳細実装**：Webpackローダーとしての統合処理は未読

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/swc/index.ts` - SWCバインディング読み込み（270行読了）
- E-02: `packages/next/src/build/swc/options.ts` - SWCオプション構築（300行読了）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getSupportedArchTriplesでプラットフォームトリプル取得 | E-01 (68-94行目) | ○ |
| C-02 | loadBindingsでネイティブ/WASMバインディング読み込み | E-01 (197-269行目) | ○ |
| C-03 | バージョン不一致チェック | E-01 (131-139行目) | ○ |
| C-04 | WASM優先対象プラットフォーム定義 | E-01 (146-154行目) | ○ |
| C-05 | Rustスタックサイズデフォルト8MB | E-01 (208-209行目) | ○ |
| C-06 | getParserOptionsでTypeScript/ECMAScript構文選択 | E-02 (39-54行目) | ○ |
| C-07 | .ts/.tsxでTypeScript構文パーサー使用 | E-02 (40-41行目) | ○ |
| C-08 | React JSX変換はruntime: 'automatic' | E-02 (152行目) | ○ |
| C-09 | emotion, styled-componentsはサーバーレイヤーで無効 | E-02 (209-215行目) | ○ |
| C-10 | modularizeImports設定のサポート | E-02 (186-202行目) | ○ |
| C-11 | Server Components/Actions変換設定 | E-02 (216-236行目) | ○ |
| C-12 | externalHelpersは非pnp環境で有効 | E-02 (126行目) | ○ |
| C-13 | removeConsole, reactRemovePropertiesのサポート | E-02 (179-184行目) | ○ |
| C-14 | SWCプラグインはrequire.resolveで解決 | E-02 (114-116行目) | ○ |
| C-15 | styledJsx変換のデフォルト有効化 | E-02 (205-207行目) | ○ |
| C-16 | next-swc-loader.tsの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Webpack SWCローダーとしての統合実装詳細
  - 候補：`packages/next/src/build/webpack/loaders/next-swc-loader.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SWCオプション構築の詳細はソースコードで完全に確認済み
- 1: 中リスク - Webpackローダーとしての統合部分は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] next-swc-loader.tsの実装を確認
- [ ] jest-transformer.tsの実装を確認
- [ ] install-bindings.tsの実装を確認
