---
generated_at: 2026-02-03 11:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-静的解析

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特に優先レビューが必要な項目はない。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/analysis/get-page-static-info.ts` - メイン静的解析モジュール（全836行読了）
- E-02: `packages/next/src/build/analysis/extract-const-value.ts` - AST定数値抽出（全257行読了）
- E-03: `packages/next/src/build/analysis/parse-module.ts` - SWCパーサーラッパー（全15行読了）
- E-04: `packages/next/src/build/segment-config/app/app-segment-config.ts` - App Routerセグメント設定（全251行読了）
- E-05: `packages/next/src/build/segment-config/pages/pages-segment-config.ts` - Pages Routerセグメント設定（全98行読了）
- E-06: `packages/next/src/build/segment-config/middleware/middleware-config.ts` - Middleware設定スキーマ（全148行読了）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PARSE_PATTERNによる事前フィルタで解析不要ファイルをスキップ | E-01 (45-46行目, 619行目, 715行目) | ○ |
| C-02 | parseModuleでSHA1ハッシュベースLRUキャッシュ（500エントリ） | E-03 (10-14行目) | ○ |
| C-03 | checkExportsでgetStaticProps等のエクスポート関数を検出 | E-01 (169-306行目) | ○ |
| C-04 | ディレクティブ（use client/use server）をAST先頭から検出 | E-01 (206-217行目) | ○ |
| C-05 | getRSCModuleInformationでコメントマーカーによるクライアント/サーバー判定 | E-01 (113-160行目) | ○ |
| C-06 | extractExportedConstValueでexport const宣言のリテラル値を抽出 | E-02 (226-256行目) | ○ |
| C-07 | extractValueがサポートする型: null, boolean, string, number, RegExp, Array, Object, TemplateLiteral等 | E-02 (103-210行目) | ○ |
| C-08 | AppSegmentConfigSchemaでZodバリデーション（revalidate, dynamic, fetchCache等） | E-04 (92-146行目) | ○ |
| C-09 | PagesSegmentConfigSchemaでZodバリデーション（runtime, maxDuration, config） | E-05 (7-34行目) | ○ |
| C-10 | Edge Runtime + generateStaticParamsの排他制約 | E-01 (674-678行目) | ○ |
| C-11 | use client + generateStaticParamsの排他制約 | E-01 (681-685行目) | ○ |
| C-12 | unstable_prefetch + cacheComponentsの制約 | E-01 (687-691行目) | ○ |
| C-13 | Proxyファイルでのランタイム指定は無効（Node.js強制） | E-01 (771-786行目) | ○ |
| C-14 | experimental-edge使用時の警告 | E-01 (542-563行目, 788-790行目) | ○ |
| C-15 | getMiddlewareMatchersでi18nロケール・basePath・nextDataパターンを追加 | E-01 (465-479行目) | ○ |
| C-16 | MiddlewareConfigInputSchemaでmatcher, regions, unstable_allowDynamicをバリデーション | E-06 (95-111行目) | ○ |
| C-17 | validateMiddlewareProxyExportsでMiddleware/Proxyファイルの有効なエクスポートを検証 | E-01 (308-428行目) | ○ |
| C-18 | apiRouteWarningsとwarnedUnsupportedValueMapがLRUキャッシュ（250エントリ）で重複抑制 | E-01 (541行目, 566行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ソースファイルを完全に読了しており、不足情報はない。
- 強いて挙げれば、`with-promise-cache.ts`と`try-to-parse-path.ts`のヘルパー関数の内部実装は未読だが、本機能の設計理解には影響しない。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主要ソースファイルを完全に読了済み
- 0: 低リスク - 型定義・Zodスキーマ・エラー処理すべてソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] with-promise-cache.tsのキャッシュ動作を確認（必要に応じて）
- [ ] try-to-parse-path.tsのパス正規表現生成ロジックを確認（必要に応じて）
- [ ] ビルドパイプラインでgetPageStaticInfoの呼び出し箇所を確認
